/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.hue.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.handler.HueLightHandler;
import org.eclipse.smarthome.binding.hue.internal.discovery.HueLightDiscoveryService;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.osgi.framework.ServiceRegistration;

public class HueThingHandlerFactory
extends BaseThingHandlerFactory {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Sets.union(HueBridgeHandler.SUPPORTED_THING_TYPES, HueLightHandler.SUPPORTED_THING_TYPES);
    private Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();

    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        if (HueBridgeHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            ThingUID hueBridgeUID = this.getBridgeThingUID(thingTypeUID, thingUID, configuration);
            return super.createThing(thingTypeUID, configuration, hueBridgeUID, null);
        }
        if (HueLightHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            ThingUID hueLightUID = this.getLightUID(thingTypeUID, thingUID, configuration, bridgeUID);
            return super.createThing(thingTypeUID, configuration, hueLightUID, bridgeUID);
        }
        throw new IllegalArgumentException("The thing type " + thingTypeUID + " is not supported by the hue binding.");
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    private ThingUID getBridgeThingUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration) {
        if (thingUID == null) {
            String serialNumber = (String)configuration.get("serialNumber");
            thingUID = new ThingUID(thingTypeUID, serialNumber);
        }
        return thingUID;
    }

    private ThingUID getLightUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration, ThingUID bridgeUID) {
        String lightId = (String)configuration.get("lightId");
        if (thingUID == null) {
            thingUID = new ThingUID(thingTypeUID, lightId, new String[]{bridgeUID.getId()});
        }
        return thingUID;
    }

    protected ThingHandler createHandler(Thing thing) {
        if (HueBridgeHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            HueBridgeHandler handler = new HueBridgeHandler((Bridge)thing);
            this.registerLightDiscoveryService(handler);
            return handler;
        }
        if (HueLightHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new HueLightHandler(thing);
        }
        return null;
    }

    private synchronized void registerLightDiscoveryService(HueBridgeHandler bridgeHandler) {
        HueLightDiscoveryService discoveryService = new HueLightDiscoveryService(bridgeHandler);
        discoveryService.activate();
        this.discoveryServiceRegs.put(bridgeHandler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof HueBridgeHandler && (serviceReg = this.discoveryServiceRegs.get(thingHandler.getThing().getUID())) != null) {
            HueLightDiscoveryService service = (HueLightDiscoveryService)this.bundleContext.getService(serviceReg.getReference());
            service.deactivate();
            serviceReg.unregister();
            this.discoveryServiceRegs.remove(thingHandler.getThing().getUID());
        }
    }
}

