/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import org.eclipse.smarthome.binding.hue.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.handler.HueLightHandler;
import org.eclipse.smarthome.binding.hue.handler.LightStatusListener;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueLightDiscoveryService
extends AbstractDiscoveryService
implements LightStatusListener {
    private final Logger logger = LoggerFactory.getLogger(HueLightDiscoveryService.class);
    private static final int SEARCH_TIME = 60;
    private HueBridgeHandler hueBridgeHandler;

    public HueLightDiscoveryService(HueBridgeHandler hueBridgeHandler) {
        super(60);
        this.hueBridgeHandler = hueBridgeHandler;
    }

    public void activate() {
        this.hueBridgeHandler.registerLightStatusListener(this);
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime());
        this.hueBridgeHandler.unregisterLightStatusListener(this);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return HueLightHandler.SUPPORTED_THING_TYPES;
    }

    public void startScan() {
        List<FullLight> lights = this.hueBridgeHandler.getFullLights();
        if (lights != null) {
            for (FullLight l : lights) {
                this.onLightAddedInternal(l);
            }
        }
        this.hueBridgeHandler.startSearch();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    @Override
    public void onLightAdded(HueBridge bridge, FullLight light) {
        this.onLightAddedInternal(light);
    }

    private void onLightAddedInternal(FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("lightId", light.getId());
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withBridge(bridgeUID).withLabel(light.getName()).build();
            this.thingDiscovered(discoveryResult);
        } else {
            this.logger.debug("discovered unsupported light of type '{}' with id {}", (Object)light.getModelID(), (Object)light.getId());
        }
    }

    @Override
    public void onLightRemoved(HueBridge bridge, FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            this.thingRemoved(thingUID);
        }
    }

    @Override
    public void onLightStateChanged(HueBridge bridge, FullLight light) {
    }

    private ThingUID getThingUID(FullLight light) {
        ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
        ThingTypeUID thingTypeUID = new ThingTypeUID("hue", light.getModelID().replaceAll("[^a-zA-Z0-9_]", "_"));
        if (this.getSupportedThingTypes().contains(thingTypeUID)) {
            String thingLightId = light.getId();
            ThingUID thingUID = new ThingUID(thingTypeUID, bridgeUID, thingLightId);
            return thingUID;
        }
        return null;
    }
}

