/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.osgi.service.component.ComponentContext;

public class LifxHandlerFactory
extends BaseThingHandlerFactory {
    public static final Collection<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Lists.newArrayList((Object[])new ThingTypeUID[]{LifxBindingConstants.THING_TYPE_COLORLIGHT, LifxBindingConstants.THING_TYPE_WHITELIGHT});

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)LifxBindingConstants.THING_TYPE_COLORLIGHT) || thingTypeUID.equals((Object)LifxBindingConstants.THING_TYPE_WHITELIGHT)) {
            return new LifxLightHandler(thing);
        }
        return null;
    }

    protected void deactivate(ComponentContext componentContext) {
        super.deactivate(componentContext);
    }
}

