/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxNetworkThrottler {
    private static Logger logger = LoggerFactory.getLogger(LifxNetworkThrottler.class);
    public static final long PACKET_INTERVAL = 50L;
    private static ConcurrentHashMap<String, ReentrantLock> locks = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> timestamps = new ConcurrentHashMap();

    public static void lock(String key) {
        if (!locks.containsKey(key)) {
            locks.put(key, new ReentrantLock());
        }
        locks.get(key).lock();
        if (timestamps.get(key) != null) {
            long lastStamp = timestamps.get(key);
            long timeToWait = Math.max(50L - (System.currentTimeMillis() - lastStamp), 0L);
            if (timeToWait > 0L) {
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException e) {
                    logger.error("An exception occurred while putting the thread to sleep : '{}'", (Object)e.getMessage());
                }
            }
        }
    }

    public static void unlock(String key) {
        if (locks.containsKey(key)) {
            timestamps.put(key, System.currentTimeMillis());
            locks.get(key).unlock();
        }
    }

    public static void lock() {
        for (ReentrantLock aLock : locks.values()) {
            aLock.lock();
        }
        long lastStamp = 0L;
        for (Long aStamp : timestamps.values()) {
            if (aStamp <= lastStamp) continue;
            lastStamp = aStamp;
        }
        long timeToWait = Math.max(50L - (System.currentTimeMillis() - lastStamp), 0L);
        if (timeToWait > 0L) {
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                logger.error("An exception occurred while putting the thread to sleep : '{}'", (Object)e.getMessage());
            }
        }
    }

    public static void unlock() {
        for (String key : locks.keySet()) {
            timestamps.put(key, System.currentTimeMillis());
            locks.get(key).unlock();
        }
    }
}

