/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

public enum Products {
    OR1000(1, 1, "Original 1000", true),
    C650(1, 3, "Color 650", true),
    W800LV(1, 10, "White 800 (Low Voltage)", false),
    W800HV(1, 11, "White 800 (High Voltage)", false),
    W900LV(1, 18, "White 900 BR30 (Low Voltage)", false),
    C900(1, 20, "Color 900 BR30", true),
    C1000(1, 22, "Color 1000", true);

    private final long vendorID;
    private final long productID;
    private final String name;
    private final boolean color;

    private Products(int vendorID, int productID, String name, boolean color) {
        this.vendorID = vendorID;
        this.productID = productID;
        this.name = name;
        this.color = color;
    }

    public String toString() {
        return this.name;
    }

    public long getVendor() {
        return this.vendorID;
    }

    public long getProduct() {
        return this.productID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isColor() {
        return this.color;
    }

    public static Products getProductFromProductID(long id) throws IllegalArgumentException {
        Products[] productsArray = Products.values();
        int n = productsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Products c = productsArray[n2];
            if (c.productID == id) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is not a valid product ID.");
    }
}

