/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.config.core.FilterCriteria;
import org.eclipse.smarthome.config.core.ParameterOption;

public class ConfigDescriptionParameter {
    private String name;
    private Type type;
    private String groupName;
    private BigDecimal min;
    private BigDecimal max;
    private BigDecimal step;
    private String pattern;
    private boolean required = false;
    private boolean readOnly = false;
    private boolean multiple = false;
    private Integer multipleLimit;
    private String unit;
    private String unitLabel;
    private String context;
    private String defaultValue;
    private String label;
    private String description;
    private List<ParameterOption> options = new ArrayList<ParameterOption>();
    private List<FilterCriteria> filterCriteria = new ArrayList<FilterCriteria>();
    private boolean limitToOptions = false;
    private boolean advanced = false;
    private static final Set<String> UNITS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("A", "cd", "K", "kg", "m", "mol", "s", "g", "rad", "sr", "Hz", "N", "Pa", "J", "W", "C", "V", "F", "\u03a9", "S", "Wb", "T", "H", "Cel", "lm", "lx", "Bq", "Gy", "Sv", "kat", "m/s2", "m2v", "m3", "kph", "%", "l", "min", "h", "d", "week", "y")));

    public ConfigDescriptionParameter() {
    }

    public ConfigDescriptionParameter(String name, Type type) throws IllegalArgumentException {
        this(name, type, null, null, null, null, false, false, false, null, null, null, null, null, null, null, false, true, null, null, null);
    }

    ConfigDescriptionParameter(String name, Type type, BigDecimal minimum, BigDecimal maximum, BigDecimal stepsize, String pattern, Boolean required, Boolean readOnly, Boolean multiple, String context, String defaultValue, String label, String description, List<ParameterOption> options, List<FilterCriteria> filterCriteria, String groupName, Boolean advanced, Boolean limitToOptions, Integer multipleLimit, String unit, String unitLabel) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The name must neither be null nor empty!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null!");
        }
        if (!(type != Type.TEXT && type != Type.BOOLEAN || unit == null && unitLabel == null)) {
            throw new IllegalArgumentException("Unit or unit label must only be set for integer or decimal configuration parameters");
        }
        if (unit != null && !UNITS.contains(unit)) {
            throw new IllegalArgumentException("The given unit is invalid.");
        }
        this.name = name;
        this.type = type;
        this.groupName = groupName;
        this.min = minimum;
        this.max = maximum;
        this.step = stepsize;
        this.pattern = pattern;
        this.context = context;
        this.defaultValue = defaultValue;
        this.label = label;
        this.description = description;
        this.multipleLimit = multipleLimit;
        this.unit = unit;
        this.unitLabel = unitLabel;
        if (readOnly != null) {
            this.readOnly = readOnly;
        }
        if (multiple != null) {
            this.multiple = multiple;
        }
        if (advanced != null) {
            this.advanced = advanced;
        }
        if (required != null) {
            this.required = required;
        }
        if (limitToOptions != null) {
            this.limitToOptions = limitToOptions;
        }
        this.options = options != null ? Collections.unmodifiableList(options) : Collections.unmodifiableList(new LinkedList());
        this.filterCriteria = filterCriteria != null ? Collections.unmodifiableList(filterCriteria) : Collections.unmodifiableList(new LinkedList());
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getMinimum() {
        return this.min;
    }

    public BigDecimal getMaximum() {
        return this.max;
    }

    public BigDecimal getStepSize() {
        return this.step;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public Boolean isMultiple() {
        return this.multiple;
    }

    public Integer getMultipleLimit() {
        return this.multipleLimit;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean getLimitToOptions() {
        return this.limitToOptions;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ParameterOption> getOptions() {
        return this.options;
    }

    public List<FilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnitLabel() {
        return this.unitLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [name=");
        sb.append(this.name);
        sb.append(", ");
        sb.append("type=");
        sb.append((Object)this.type);
        if (this.groupName != null) {
            sb.append(", ");
            sb.append("groupName=");
            sb.append(this.groupName);
        }
        if (this.min != null) {
            sb.append(", ");
            sb.append("min=");
            sb.append(this.min);
        }
        if (this.max != null) {
            sb.append(", ");
            sb.append("max=");
            sb.append(this.max);
        }
        if (this.step != null) {
            sb.append(", ");
            sb.append("step=");
            sb.append(this.step);
        }
        if (this.pattern != null) {
            sb.append(", ");
            sb.append("pattern=");
            sb.append(this.pattern);
        }
        sb.append(", ");
        sb.append("readOnly=");
        sb.append(this.readOnly);
        sb.append(", ");
        sb.append("required=");
        sb.append(this.required);
        sb.append(", ");
        sb.append("multiple=");
        sb.append(this.multiple);
        sb.append(", ");
        sb.append("multipleLimit=");
        sb.append(this.multipleLimit);
        if (this.context != null) {
            sb.append(", ");
            sb.append("context=");
            sb.append(this.context);
        }
        if (this.label != null) {
            sb.append(", ");
            sb.append("label=");
            sb.append(this.label);
        }
        if (this.description != null) {
            sb.append(", ");
            sb.append("description=");
            sb.append(this.description);
        }
        if (this.defaultValue != null) {
            sb.append(", ");
            sb.append("defaultValue=");
            sb.append(this.defaultValue);
        }
        if (this.unit != null) {
            sb.append(", ");
            sb.append("unit=");
            sb.append(this.unit);
        }
        if (this.unitLabel != null) {
            sb.append(", ");
            sb.append("unitLabel=");
            sb.append(this.unitLabel);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        TEXT,
        INTEGER,
        DECIMAL,
        BOOLEAN;

    }
}

