/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.normalization.Normalizer;
import org.eclipse.smarthome.config.core.normalization.NormalizerFactory;

public class ConfigUtil {
    public static Map<String, Object> normalizeTypes(Map<String, Object> configuration) {
        HashMap<String, Object> convertedConfiguration = new HashMap<String, Object>(configuration.size());
        for (Map.Entry<String, Object> parameter : configuration.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            convertedConfiguration.put(name, ConfigUtil.normalizeType(value));
        }
        return convertedConfiguration;
    }

    public static Object normalizeType(Object value) {
        return value instanceof Double ? BigDecimal.valueOf((Double)value) : value;
    }

    public static Map<String, Object> normalizeTypes(Map<String, Object> configuration, ConfigDescription configDescription) {
        Preconditions.checkNotNull((Object)configDescription, (Object)"Config description must not be null.");
        if (configuration == null) {
            return null;
        }
        HashMap<String, Object> convertedConfiguration = new HashMap<String, Object>(configuration.size());
        Map<String, ConfigDescriptionParameter> configParams = configDescription.toParametersMap();
        for (Map.Entry<String, Object> parameter : configuration.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            ConfigDescriptionParameter configDescriptionParameter = configParams.get(name);
            if (configDescriptionParameter != null) {
                Normalizer normalizer = NormalizerFactory.getNormalizer(configDescriptionParameter);
                convertedConfiguration.put(name, normalizer.normalize(value));
                continue;
            }
            convertedConfiguration.put(name, value);
        }
        return convertedConfiguration;
    }
}

