/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.BindingInfoProvider;

public class BindingInfoRegistry {
    private Collection<BindingInfoProvider> bindingInfoProviders = new CopyOnWriteArrayList<BindingInfoProvider>();

    protected void addBindingInfoProvider(BindingInfoProvider bindingInfoProvider) {
        if (bindingInfoProvider != null) {
            this.bindingInfoProviders.add(bindingInfoProvider);
        }
    }

    protected void removeBindingInfoProvider(BindingInfoProvider bindingInfoProvider) {
        if (bindingInfoProvider != null) {
            this.bindingInfoProviders.remove(bindingInfoProvider);
        }
    }

    public BindingInfo getBindingInfo(String id) {
        return this.getBindingInfo(id, null);
    }

    public BindingInfo getBindingInfo(String id, Locale locale) {
        for (BindingInfoProvider bindingInfoProvider : this.bindingInfoProviders) {
            BindingInfo bindingInfo = bindingInfoProvider.getBindingInfo(id, locale);
            if (bindingInfo == null) continue;
            return bindingInfo;
        }
        return null;
    }

    public Set<BindingInfo> getBindingInfos() {
        return this.getBindingInfos(null);
    }

    public Set<BindingInfo> getBindingInfos(Locale locale) {
        LinkedHashSet<BindingInfo> allBindingInfos = new LinkedHashSet<BindingInfo>(10);
        for (BindingInfoProvider bindingInfoProvider : this.bindingInfoProviders) {
            Set<BindingInfo> bindingInfos = bindingInfoProvider.getBindingInfos(locale);
            allBindingInfos.addAll(bindingInfos);
        }
        return Collections.unmodifiableSet(allBindingInfos);
    }
}

