/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolManager.class);
    protected static final int DEFAULT_THREAD_POOL_MAX_SIZE = 10;
    protected static final int DEFAULT_THREAD_POOL_CORE_SIZE = 5;
    protected static final long THREAD_TIMEOUT = 65L;
    protected static final long THREAD_MONITOR_SLEEP = 60000L;
    protected static Map<String, ExecutorService> pools = new WeakHashMap<String, ExecutorService>();
    private static Map<String, int[]> configs = new ConcurrentHashMap<String, int[]>();

    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    protected void modified(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("service.pid") || entry.getKey().equals("component.id") || entry.getKey().equals("component.name")) continue;
            String poolName = entry.getKey();
            Object config = entry.getValue();
            if (config == null) {
                configs.remove(poolName);
            }
            if (!(config instanceof String)) continue;
            String[] segments = ((String)config).split(",");
            if (segments.length > 2) {
                logger.warn("Ignoring invalid configuration for pool '{}': {} - config have at most 2 parts", new Object[]{poolName, config});
                continue;
            }
            try {
                int[] nArray;
                Integer coreSize = Integer.valueOf(segments[0]);
                if (segments.length == 1) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = coreSize;
                    nArray = nArray2;
                    nArray2[1] = coreSize > 10 ? coreSize : 10;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = coreSize;
                    nArray = nArray3;
                    nArray3[1] = Integer.valueOf(segments[1]);
                }
                int[] cfg = nArray;
                if (cfg[0] > cfg[1]) {
                    logger.warn("Ignoring invalid configuration for pool '{}': {} - max value must be bigger than min value", new Object[]{poolName, config});
                    continue;
                }
                if (cfg[0] < 0 || cfg[1] < 0) {
                    logger.warn("Ignoring invalid configuration for pool '{}': {} - value must not be negative", new Object[]{poolName, config});
                    continue;
                }
                configs.put(poolName, cfg);
                ThreadPoolExecutor pool = (ThreadPoolExecutor)pools.get(poolName);
                if (pool == null) continue;
                if (pool instanceof ScheduledExecutorService) {
                    pool.setCorePoolSize(cfg[0]);
                    logger.debug("Updated scheduled thread pool '{}' to size {}", new Object[]{poolName, cfg[0]});
                    continue;
                }
                pool.setCorePoolSize(cfg[0]);
                pool.setMaximumPoolSize(cfg[1]);
                logger.debug("Updated thread pool '{}' to size {}-{}", new Object[]{poolName, cfg[0], cfg[1]});
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Ignoring invalid configuration for pool '{}': {} - entries must be integer values", new Object[]{poolName, config});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService getScheduledPool(String poolName) {
        ExecutorService pool = pools.get(poolName);
        if (pool == null) {
            Map<String, ExecutorService> map = pools;
            synchronized (map) {
                pool = pools.get(poolName);
                if (pool == null) {
                    int[] cfg = ThreadPoolManager.getConfig(poolName);
                    pool = Executors.newScheduledThreadPool(cfg[0], new NamedThreadFactory(poolName));
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    pools.put(poolName, pool);
                    logger.debug("Created scheduled thread pool '{}' of size {}", new Object[]{poolName, cfg[0]});
                }
            }
        }
        if (pool instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)pool;
        }
        throw new IllegalArgumentException("Pool " + poolName + " is not a scheduled pool!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getPool(String poolName) {
        ExecutorService pool = pools.get(poolName);
        if (pool == null) {
            Map<String, ExecutorService> map = pools;
            synchronized (map) {
                pool = pools.get(poolName);
                if (pool == null) {
                    int[] cfg = ThreadPoolManager.getConfig(poolName);
                    pool = new CommonThreadExecutor(poolName, cfg[0], cfg[1]);
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    pools.put(poolName, pool);
                    logger.debug("Created thread pool '{}' with size {}-{}", new Object[]{poolName, cfg[0], cfg[1]});
                }
            }
        }
        return pool;
    }

    protected static int[] getConfig(String poolName) {
        int[] nArray;
        int[] cfg = configs.get(poolName);
        if (cfg != null) {
            nArray = cfg;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 5;
            nArray = nArray2;
            nArray2[1] = 10;
        }
        return nArray;
    }

    private static class CommonThreadExecutor
    extends ThreadPoolExecutor {
        public CommonThreadExecutor(final String poolName, int corePoolSize, int maxPoolSize) {
            this(poolName, corePoolSize, maxPoolSize, new NamedThreadFactory(poolName), new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    logger.warn("Thread pool '{}' rejected execution of {}", new Object[]{poolName, runnable.getClass()});
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        public CommonThreadExecutor(String threadPool, int corePoolSize, int maxPoolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
            super(corePoolSize, maxPoolSize, 65L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, rejectedHandler);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            Throwable cause;
            super.afterExecute(runnable, throwable);
            if (throwable != null && (cause = throwable.getCause()) instanceof InterruptedException) {
                return;
            }
        }
    }

    protected static class NamedThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String namePrefix;
        protected final String name;

        public NamedThreadFactory(String threadPool) {
            this.name = threadPool;
            this.namePrefix = "ESH-" + threadPool + "-";
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        public String getName() {
            return this.name;
        }
    }
}

