/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.osgi;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public abstract class ResolvedBundleTracker
implements SynchronousBundleListener {
    private BundleContext bundleContext;
    private List<Bundle> trackedBundles;

    public ResolvedBundleTracker(BundleContext bundleContext) throws IllegalArgumentException {
        if (bundleContext == null) {
            throw new IllegalArgumentException("The bundle context must not be null!");
        }
        this.bundleContext = bundleContext;
        this.trackedBundles = new ArrayList<Bundle>();
    }

    public synchronized void open() {
        this.bundleContext.addBundleListener((BundleListener)this);
        this.initialize();
    }

    public synchronized void close() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.uninitialize();
    }

    private synchronized void initialize() {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean shouldNotBeTracked;
            Bundle bundle = bundleArray[n2];
            int state = bundle.getState();
            boolean bl = shouldNotBeTracked = (state & 3) > 0;
            if (shouldNotBeTracked) {
                this.remove(bundle);
            } else {
                this.add(bundle);
            }
            ++n2;
        }
    }

    private synchronized void uninitialize() {
        for (Bundle bundle : this.trackedBundles) {
            try {
                this.removedBundle(bundle);
            }
            catch (Exception exception) {}
        }
        this.trackedBundles.clear();
    }

    public synchronized void bundleChanged(BundleEvent event) {
        boolean shouldNotBeTracked;
        Bundle bundle = event.getBundle();
        int type = event.getType();
        boolean shouldBeTracked = (type & 0xA2) > 0;
        boolean bl = shouldNotBeTracked = (type & 0x50) > 0;
        if (shouldBeTracked) {
            this.add(bundle);
        } else if (shouldNotBeTracked) {
            this.remove(bundle);
        }
    }

    private void add(Bundle bundle) {
        if (!this.trackedBundles.contains(bundle)) {
            try {
                if (this.addingBundle(bundle)) {
                    this.trackedBundles.add(bundle);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void remove(Bundle bundle) {
        if (this.trackedBundles.contains(bundle)) {
            try {
                try {
                    this.removedBundle(bundle);
                }
                catch (Exception exception) {
                    this.trackedBundles.remove(bundle);
                }
            }
            finally {
                this.trackedBundles.remove(bundle);
            }
        }
    }

    public boolean addingBundle(Bundle bundle) {
        return false;
    }

    public void removedBundle(Bundle bundle) {
    }
}

