/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.internal.i18n.LanguageResourceBundleManager;
import org.eclipse.smarthome.core.internal.i18n.ResourceBundleTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class I18nProviderImpl
implements I18nProvider {
    private LocaleProvider localeProvider;
    private ResourceBundleTracker resourceBundleTracker;

    protected void activate(BundleContext bundleContext) {
        this.resourceBundleTracker = new ResourceBundleTracker(bundleContext, this.localeProvider);
        this.resourceBundleTracker.open();
    }

    protected void deactivate(BundleContext bundleContext) {
        this.resourceBundleTracker.close();
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        if (this.localeProvider == localeProvider) {
            this.localeProvider = null;
        }
    }

    @Override
    public String getText(Bundle bundle, String key, String defaultText, Locale locale) {
        String text;
        LanguageResourceBundleManager languageResource = this.resourceBundleTracker.getLanguageResource(bundle);
        if (languageResource != null && (text = languageResource.getText(key, locale)) != null) {
            return text;
        }
        return defaultText;
    }

    @Override
    public String getText(Bundle bundle, String key, String defaultText, Locale locale, Object ... arguments) {
        String text = this.getText(bundle, key, defaultText, locale);
        if (text != null) {
            return MessageFormat.format(text, arguments);
        }
        return text;
    }
}

