/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.service.AbstractWatchQueueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected WatchService watchService;
    protected AbstractWatchQueueReader watchQueueReader;

    public void activate() {
        this.initializeWatchService();
    }

    public void deactivate() {
        this.stopWatchService();
    }

    protected void initializeWatchService() {
        String pathToWatch;
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                this.logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)(pathToWatch = this.getSourcePath()))) {
            Path toWatch = Paths.get(pathToWatch, new String[0]);
            try {
                if (this.watchSubDirectories()) {
                    this.watchService = FileSystems.getDefault().newWatchService();
                    Files.walkFileTree(toWatch, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path subDir, BasicFileAttributes attrs) throws IOException {
                            AbstractWatchService.this.registerDirectory(subDir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                } else {
                    this.watchService = toWatch.getFileSystem().newWatchService();
                    this.registerDirectory(toWatch);
                }
                AbstractWatchQueueReader reader = this.buildWatchQueueReader(this.watchService, toWatch);
                Thread qr = new Thread((Runnable)reader, "Dir Watcher");
                qr.start();
            }
            catch (IOException e) {
                this.logger.error("Cannot activate folder watcher for folder '{}': {}", (Object)toWatch, (Object)e.getMessage());
            }
        }
    }

    protected void stopWatchService() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                this.logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
            this.watchService = null;
        }
    }

    protected abstract AbstractWatchQueueReader buildWatchQueueReader(WatchService var1, Path var2);

    protected abstract String getSourcePath();

    protected abstract boolean watchSubDirectories();

    protected abstract void registerDirectory(Path var1) throws IOException;
}

