/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.actions;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.smarthome.designer.core.config.ConfigurationFolderProvider;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectConfigFolderAction
extends Action {
    Viewer viewer;

    public SelectConfigFolderAction(Viewer viewer) {
        this.viewer = viewer;
        this.setText("Select configuration folder");
        this.setToolTipText("select a configuration folder");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
        dialog.setMessage("Select the configuration folder of the Eclipse SmartHome runtime");
        String selection = dialog.open();
        if (selection != null) {
            try {
                File file = new File(selection);
                if (this.isValidConfigurationFolder(file)) {
                    ConfigurationFolderProvider.saveFolderToPreferences((String)selection);
                    ConfigurationFolderProvider.setRootConfigurationFolder((File)new File(selection));
                    this.viewer.setInput((Object)ConfigurationFolderProvider.getRootConfigurationFolder());
                } else {
                    MessageDialog.openError((Shell)shell, (String)"No valid configuration directory", (String)"The chosen directory is not a valid Eclipse SmartHome configuration directory. Please choose a different one.");
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.smarthome.designer.ui", "An error occurred while opening the configuration folder", (Throwable)e);
                ErrorDialog.openError((Shell)shell, (String)"Cannot open configuration folder!", null, (IStatus)status);
            }
        }
    }

    private boolean isValidConfigurationFolder(File dir) {
        return dir.isDirectory();
    }
}

