/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.smarthome.designer.core.config.ConfigurationFolderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private final Logger logger = LoggerFactory.getLogger(ViewContentProvider.class);
    private IFolder configRootFolder;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof IFolder) {
            this.configRootFolder = (IFolder)newInput;
        }
    }

    public void dispose() {
        this.configRootFolder = null;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IProject) {
            try {
                this.configRootFolder = ConfigurationFolderProvider.getRootConfigurationFolder();
                if (this.configRootFolder != null) {
                    return this.getChildren(this.configRootFolder);
                }
                return new String[]{"<select a configuration folder>"};
            }
            catch (CoreException e) {
                this.logger.error("Cannot initialize configuration project in workspace", (Throwable)e);
                return new Object[0];
            }
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child.equals(this.configRootFolder)) {
            return null;
        }
        if (child instanceof IResource) {
            IResource res = (IResource)child;
            return res.getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IFolder) {
            IFolder folder = (IFolder)parent;
            try {
                IResource[] resources = folder.members();
                ArrayList<IResource> children = new ArrayList<IResource>(resources.length);
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    if (!child.getName().startsWith(".")) {
                        children.add(child);
                    }
                    ++n2;
                }
                return children.toArray(new IResource[children.size()]);
            }
            catch (CoreException e) {
                this.logger.warn("Error getting children for folder '{}'", (Object)folder.getName(), (Object)e);
            }
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }
}

