/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JSONResponse {
    public static final String JSON_KEY_ERROR_MESSAGE = "message";
    public static final String JSON_KEY_ERROR = "error";
    public static final String JSON_KEY_HTTPCODE = "http-code";
    private static final boolean WITH_STACKTRACE = false;
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    JSONResponse() {
    }

    private static Response.ResponseBuilder response(Response.Status status) {
        return Response.status((Response.Status)status).header("Content-Type", (Object)"application/json");
    }

    private static JsonElement createErrorJson(String message, Response.Status status, Object entity, Exception ex) {
        JsonObject ret = new JsonObject();
        JsonObject err = new JsonObject();
        ret.add(JSON_KEY_ERROR, (JsonElement)err);
        err.addProperty(JSON_KEY_ERROR_MESSAGE, message);
        if (status != null) {
            err.addProperty(JSON_KEY_HTTPCODE, (Number)status.getStatusCode());
        }
        if (entity != null) {
            ret.add("entity", GSON.toJsonTree(entity));
        }
        if (ex != null) {
            JsonObject exc = new JsonObject();
            err.add("exception", (JsonElement)exc);
            exc.addProperty("class", ex.getClass().getName());
            exc.addProperty(JSON_KEY_ERROR_MESSAGE, ex.getMessage());
            exc.addProperty("localized-message", ex.getLocalizedMessage());
            exc.addProperty("cause", ex.getCause() != null ? ex.getCause().getClass().getName() : null);
        }
        return ret;
    }

    public static Response createErrorResponse(Response.Status status, String errormessage) {
        return JSONResponse.createResponse(status, null, errormessage);
    }

    public static Response createResponse(Response.Status status, Object entity, String errormessage) {
        JsonElement ret = status.getFamily() == Response.Status.Family.SUCCESSFUL ? (entity != null ? GSON.toJsonTree(entity) : null) : JSONResponse.createErrorJson(errormessage, status, entity, null);
        Response.ResponseBuilder rp = JSONResponse.response(status);
        if (ret != null) {
            rp = rp.entity((Object)GSON.toJson(ret));
        }
        return rp.build();
    }

    @Provider
    public static class ExceptionMapper
    implements javax.ws.rs.ext.ExceptionMapper<Exception> {
        private final Logger logger = LoggerFactory.getLogger(ExceptionMapper.class);

        public Response toResponse(Exception e) {
            this.logger.debug("exception during REST Handling", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (e instanceof WebApplicationException) {
                status = (Response.Status)((WebApplicationException)e).getResponse().getStatusInfo();
            }
            JsonElement ret = JSONResponse.createErrorJson(e.getMessage(), status, null, e);
            return JSONResponse.response(status).entity((Object)GSON.toJson(ret)).build();
        }
    }
}

