/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelGroupFunction implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    NAND(2, "NAND", "NAND"),
    NOR(3, "NOR", "NOR"),
    AVG(4, "AVG", "AVG"),
    SUM(5, "SUM", "SUM"),
    MAX(6, "MAX", "MAX"),
    MIN(7, "MIN", "MIN"),
    COUNT(8, "COUNT", "COUNT");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int NAND_VALUE = 2;
    public static final int NOR_VALUE = 3;
    public static final int AVG_VALUE = 4;
    public static final int SUM_VALUE = 5;
    public static final int MAX_VALUE = 6;
    public static final int MIN_VALUE = 7;
    public static final int COUNT_VALUE = 8;
    private static final ModelGroupFunction[] VALUES_ARRAY;
    public static final List<ModelGroupFunction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelGroupFunction[]{AND, OR, NAND, NOR, AVG, SUM, MAX, MIN, COUNT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelGroupFunction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return NAND;
            }
            case 3: {
                return NOR;
            }
            case 4: {
                return AVG;
            }
            case 5: {
                return SUM;
            }
            case 6: {
                return MAX;
            }
            case 7: {
                return MIN;
            }
            case 8: {
                return COUNT;
            }
        }
        return null;
    }

    private ModelGroupFunction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

