/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.persistence.extensions;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.LoggerFactory;

public class PersistenceExtensions
implements ManagedService {
    private static Map<String, PersistenceService> services = new HashMap<String, PersistenceService>();
    private static String defaultService = null;

    public void addPersistenceService(PersistenceService service) {
        services.put(service.getName(), service);
    }

    public void removePersistenceService(PersistenceService service) {
        services.remove(service.getName());
    }

    public static void persist(Item item, String serviceName) {
        PersistenceService service = services.get(serviceName);
        if (service != null) {
            service.store(item);
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no persistence service registered with the name '{}'", (Object)serviceName);
        }
    }

    public static void persist(Item item) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            PersistenceExtensions.persist(item, defaultService);
        }
    }

    public static HistoricItem historicState(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.historicState(item, timestamp, defaultService);
        }
        return null;
    }

    public static HistoricItem historicState(Item item, AbstractInstant timestamp, String serviceName) {
        PersistenceService service = services.get(serviceName);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setEndDate(timestamp.toDate());
            filter.setItemName(item.getName());
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            Iterable result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return (HistoricItem)result.iterator().next();
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the name '{}'", (Object)serviceName);
        return null;
    }

    public static Boolean changedSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.changedSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static Boolean changedSince(Item item, AbstractInstant timestamp, String serviceName) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceName);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp);
        if (itemThen == null) {
            return it.hasNext();
        }
        State state = itemThen.getState();
        while (it.hasNext()) {
            HistoricItem hItem = it.next();
            if (state != null && !hItem.getState().equals(state)) {
                return true;
            }
            state = hItem.getState();
        }
        return false;
    }

    public static Boolean updatedSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.updatedSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static Boolean updatedSince(Item item, AbstractInstant timestamp, String serviceName) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceName);
        if (result.iterator().hasNext()) {
            return true;
        }
        return false;
    }

    public static HistoricItem maximumSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.maximumSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static HistoricItem maximumSince(final Item item, AbstractInstant timestamp, String serviceName) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceName);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem maximumHistoricItem = null;
        DecimalType maximum = (DecimalType)item.getStateAs(DecimalType.class);
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            DecimalType value = (DecimalType)state;
            if (maximum != null && value.compareTo(maximum) <= 0) continue;
            maximum = value;
            maximumHistoricItem = historicItem;
        }
        if (maximumHistoricItem == null && maximum != null) {
            final DecimalType state = maximum;
            return new HistoricItem(){

                public Date getTimestamp() {
                    return Calendar.getInstance().getTime();
                }

                public State getState() {
                    return state;
                }

                public String getName() {
                    return item.getName();
                }
            };
        }
        return maximumHistoricItem;
    }

    public static HistoricItem minimumSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.minimumSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static HistoricItem minimumSince(final Item item, AbstractInstant timestamp, String serviceName) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceName);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem minimumHistoricItem = null;
        DecimalType minimum = (DecimalType)item.getStateAs(DecimalType.class);
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            DecimalType value = (DecimalType)state;
            if (minimum != null && value.compareTo(minimum) >= 0) continue;
            minimum = value;
            minimumHistoricItem = historicItem;
        }
        if (minimumHistoricItem == null && minimum != null) {
            final DecimalType state = minimum;
            return new HistoricItem(){

                public Date getTimestamp() {
                    return Calendar.getInstance().getTime();
                }

                public State getState() {
                    return state;
                }

                public String getName() {
                    return item.getName();
                }
            };
        }
        return minimumHistoricItem;
    }

    public static DecimalType averageSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.averageSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static DecimalType averageSince(Item item, AbstractInstant timestamp, String serviceName) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceName);
        Iterator<HistoricItem> it = result.iterator();
        DecimalType value = (DecimalType)item.getStateAs(DecimalType.class);
        if (value == null) {
            value = DecimalType.ZERO;
        }
        double average = value.doubleValue();
        int quantity = 1;
        while (it.hasNext()) {
            State state = it.next().getState();
            if (!(state instanceof DecimalType)) continue;
            value = (DecimalType)state;
            average += value.doubleValue();
            ++quantity;
        }
        return new DecimalType(average /= (double)quantity);
    }

    private static Iterable<HistoricItem> getAllStatesSince(Item item, AbstractInstant timestamp, String serviceName) {
        PersistenceService service = services.get(serviceName);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setBeginDate(timestamp.toDate());
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            return qService.query(filter);
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the name '{}'", (Object)serviceName);
        return Collections.emptySet();
    }

    public static AbstractInstant lastUpdate(Item item) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.lastUpdate(item, defaultService);
        }
        return null;
    }

    public static AbstractInstant lastUpdate(Item item, String serviceName) {
        PersistenceService service = services.get(serviceName);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(1);
            Iterable result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return new DateTime((Object)((HistoricItem)result.iterator().next()).getTimestamp());
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the name '{}'", (Object)serviceName);
        return null;
    }

    public static DecimalType deltaSince(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.deltaSince(item, timestamp, defaultService);
        }
        return null;
    }

    public static DecimalType deltaSince(Item item, AbstractInstant timestamp, String serviceName) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceName);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState();
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueNow != null) {
                return new DecimalType(valueNow.doubleValue() - valueThen.doubleValue());
            }
        }
        return null;
    }

    public static DecimalType evolutionRate(Item item, AbstractInstant timestamp) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.evolutionRate(item, timestamp, defaultService);
        }
        return null;
    }

    public static DecimalType evolutionRate(Item item, AbstractInstant timestamp, String serviceName) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceName);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState();
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueNow != null) {
                return new DecimalType(100.0 * (valueNow.doubleValue() - valueThen.doubleValue()) / valueThen.doubleValue());
            }
        }
        return null;
    }

    public static HistoricItem previousState(Item item) {
        return PersistenceExtensions.previousState(item, false);
    }

    public static HistoricItem previousState(Item item, boolean skipEqual) {
        if (PersistenceExtensions.isDefaultServiceAvailable()) {
            return PersistenceExtensions.previousState(item, skipEqual, defaultService);
        }
        return null;
    }

    public static HistoricItem previousState(Item item, boolean skipEqual, String serviceName) {
        PersistenceService service = services.get(serviceName);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(skipEqual ? 1000 : 1);
            int startPage = 0;
            filter.setPageNumber(startPage);
            Iterable items = qService.query(filter);
            while (items != null) {
                Iterator itemIterator = items.iterator();
                int itemCount = 0;
                while (itemIterator.hasNext()) {
                    HistoricItem historicItem = (HistoricItem)itemIterator.next();
                    ++itemCount;
                    if (skipEqual && (!skipEqual || historicItem.getState().equals(item.getState()))) continue;
                    return historicItem;
                }
                if (itemCount == filter.getPageSize()) {
                    filter.setPageNumber(++startPage);
                    items = qService.query(filter);
                    continue;
                }
                items = null;
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the name '{}'", (Object)serviceName);
        return null;
    }

    private static boolean isDefaultServiceAvailable() {
        if (defaultService != null) {
            return true;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("No default persistence service is configured in smarthome.cfg!");
        return false;
    }

    public void updated(Dictionary config) throws ConfigurationException {
        if (config != null) {
            defaultService = (String)config.get("default");
        }
    }
}

