/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.sitemap.internal;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapProviderImpl
implements SitemapProvider {
    protected static final String SITEMAP_FILEEXT = ".sitemap";
    private final Logger logger = LoggerFactory.getLogger(SitemapProviderImpl.class);
    private ModelRepository modelRepo = null;

    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    @Override
    public Sitemap getSitemap(String sitemapName) {
        if (this.modelRepo != null) {
            Sitemap sitemap = (Sitemap)this.modelRepo.getModel(String.valueOf(sitemapName) + SITEMAP_FILEEXT);
            if (sitemap != null) {
                return sitemap;
            }
            this.logger.trace("Sitemap {} cannot be found", (Object)sitemapName);
            return null;
        }
        this.logger.debug("No model repository service is available");
        return null;
    }

    @Override
    public Set<String> getSitemapNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.modelRepo != null) {
            for (String name : this.modelRepo.getAllModelNamesOfType("sitemap")) {
                names.add(StringUtils.removeEnd((String)name, (String)SITEMAP_FILEEXT));
            }
        } else {
            this.logger.debug("No model repository service is available");
        }
        return names;
    }
}

