/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon;

import java.io.InputStream;
import java.util.Set;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.osgi.framework.BundleContext;

public abstract class AbstractResourceIconProvider
implements IconProvider {
    protected BundleContext context;
    protected I18nProvider i18nProvider;

    protected void activate(BundleContext context) {
        this.context = context;
    }

    protected void setI18nProvider(I18nProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetI18nProvider(I18nProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Override
    public Set<IconSet> getIconSets() {
        return this.getIconSets(null);
    }

    @Override
    public Integer hasIcon(String category, String iconSetId, IconSet.Format format) {
        return this.hasResource(iconSetId, String.valueOf(category.toLowerCase()) + "." + format.toString().toLowerCase()) ? this.getPriority() : null;
    }

    @Override
    public InputStream getIcon(String category, String iconSetId, String state, IconSet.Format format) {
        String resourceWithState = String.valueOf(category) + (state != null ? "-" + state.toLowerCase() : "") + "." + format.toString().toLowerCase();
        if (this.hasResource(iconSetId, resourceWithState)) {
            return this.getResource(iconSetId, resourceWithState);
        }
        try {
            Double stateAsDouble = Double.valueOf(state);
            if (stateAsDouble >= 0.0 && stateAsDouble <= 100.0) {
                int i = stateAsDouble.intValue();
                while (i >= 0) {
                    String resourceWithNumberState = String.valueOf(category) + "-" + i + "." + format.toString().toLowerCase();
                    if (this.hasResource(iconSetId, resourceWithNumberState)) {
                        return this.getResource(iconSetId, resourceWithNumberState);
                    }
                    --i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this.getResource(iconSetId, String.valueOf(category) + "." + format.toString().toLowerCase());
    }

    protected abstract Integer getPriority();

    protected abstract InputStream getResource(String var1, String var2);

    protected abstract boolean hasResource(String var1, String var2);
}

