/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;

@Path(value="iconsets")
public class IconSetResource
implements RESTResource {
    private List<IconProvider> iconProviders = new ArrayList<IconProvider>(5);
    @Context
    UriInfo uriInfo;

    protected void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    protected void removeIconProvider(IconProvider iconProvider) {
        this.iconProviders.remove(iconProvider);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAll(@HeaderParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ArrayList<IconSet> iconSets = new ArrayList<IconSet>(this.iconProviders.size());
        for (IconProvider iconProvider : this.iconProviders) {
            iconSets.addAll(iconProvider.getIconSets(locale));
        }
        return Response.ok(iconSets).build();
    }
}

