/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.iconset.classic.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.ui.icon.AbstractResourceIconProvider;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicIconProvider
extends AbstractResourceIconProvider
implements IconProvider {
    private final Logger logger = LoggerFactory.getLogger(ClassicIconProvider.class);
    static String ICONSET_ID = "classic";

    public Set<IconSet> getIconSets(Locale locale) {
        HashSet<IconSet.Format> formats = new HashSet<IconSet.Format>(2);
        formats.add(IconSet.Format.PNG);
        formats.add(IconSet.Format.SVG);
        String label = this.i18nProvider.getText(this.context.getBundle(), "iconset.label", "Classic Icons", locale);
        String description = this.i18nProvider.getText(this.context.getBundle(), "iconset.description", "This is a modernized version of the original icon set of openHAB 1.", locale);
        IconSet iconSet = new IconSet(ICONSET_ID, label, description, formats);
        return Collections.singleton(iconSet);
    }

    protected InputStream getResource(String iconSetId, String resourceName) {
        if (ICONSET_ID.equals(iconSetId)) {
            URL iconResource = this.context.getBundle().getEntry("icons" + File.separator + resourceName);
            try {
                return iconResource.openStream();
            }
            catch (IOException e) {
                this.logger.error("Failed to read icon '{}': {}", (Object)resourceName, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    protected boolean hasResource(String iconSetId, String resourceName) {
        if (ICONSET_ID.equals(iconSetId)) {
            URL iconResource = this.context.getBundle().getEntry("icons" + File.separator + resourceName);
            return iconResource != null;
        }
        return false;
    }

    protected Integer getPriority() {
        return 0;
    }
}

