/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.api.internal.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.model.xpdl.api.internal.adapters.IAdapterFactory;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;

public class AdapterRegistry {
    private final Map registry = new HashMap();

    public Object getAdapter(Object adaptee, IAdapterFactory adapterFactory) {
        WeakHashMap adapters = (WeakHashMap)this.registry.get(adapterFactory);
        if (adapters == null) {
            adapters = new WeakHashMap();
            this.registry.put(adapterFactory, adapters);
        }
        if (adaptee == null) {
            return null;
        }
        Object result = adapters.get(adaptee);
        if (result == null && (result = adapterFactory.createAdapter(adaptee)) != null) {
            adapters.put(adaptee, result);
        }
        return result;
    }

    public Object getAdapter(EObject scope, EStructuralFeature feature, String id, IAdapterFactory adapterFactory) {
        return this.getAdapter(scope, feature, id, null, adapterFactory);
    }

    public Object getAdapter(EObject scope, EStructuralFeature feature, String id, Predicate predicate, IAdapterFactory adapterFactory) {
        Object rawDomain;
        Object result = null;
        if (scope != null && scope != null && (rawDomain = scope.eGet(feature)) instanceof List) {
            List domain = (List)rawDomain;
            result = this.getAdapter(domain, id, predicate, adapterFactory);
        }
        return result;
    }

    public Object getAdapter(List domain, String id, IAdapterFactory adapterFactory) {
        return this.getAdapter(domain, id, null, adapterFactory);
    }

    public Object getAdapter(List domain, String id, Predicate predicate, IAdapterFactory adapterFactory) {
        Object result = null;
        int i = 0;
        while (i < domain.size()) {
            Object candidate = domain.get(i);
            if (candidate instanceof IIdentifiableElement && (predicate == null || predicate.accept(candidate)) && CompareHelper.areEqual((Object)((IIdentifiableElement)candidate).getId(), (Object)id)) {
                result = this.getAdapter(candidate, adapterFactory);
                break;
            }
            ++i;
        }
        return result;
    }

    public List getAdapters(EObject scope, EStructuralFeature feature, IAdapterFactory adapterFactory) {
        return this.getAdapters(scope, feature, null, adapterFactory);
    }

    public List getAdapters(EObject scope, EStructuralFeature feature, Predicate predicate, IAdapterFactory adapterFactory) {
        Object adaptees;
        List result = null;
        if (scope != null && (adaptees = scope.eGet(feature)) instanceof List) {
            result = this.getAdapters((List)adaptees, predicate, adapterFactory);
        }
        return result != null ? result : Collections.EMPTY_LIST;
    }

    public List getAdapters(List adaptees, IAdapterFactory adapterFactory) {
        return this.getAdapters(adaptees, null, adapterFactory);
    }

    public List getAdapters(List adaptees, Predicate predicate, IAdapterFactory adapterFactory) {
        ArrayList<Object> result = null;
        int i = 0;
        while (i < adaptees.size()) {
            Object adapter;
            Object adaptee = adaptees.get(i);
            if ((predicate == null || predicate.accept(adaptee)) && (adapter = this.getAdapter(adaptee, adapterFactory)) != null) {
                if (result == null) {
                    result = new ArrayList<Object>(adaptees.size());
                }
                result.add(adapter);
            }
            ++i;
        }
        return result != null ? result : Collections.EMPTY_LIST;
    }
}

