/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DatabaseFacade;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.IntervalList;
import org.eclipse.stardust.ide.simulation.ui.validation.SimulationFailedException;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class ArrivalRateAuditTrailQuery
implements IAuditTrailQuery {
    String sql;
    String objectHint;

    protected ArrivalRateAuditTrailQuery(String objectHint, ProcessDefinitionType process, long startDate, long endDate, String schemaPrefix, String partitionId) {
        this.objectHint = objectHint;
        this.sql = "SELECT I.starttime FROM " + schemaPrefix + "process_instance I" + " INNER JOIN " + schemaPrefix + "process_definition P ON P.model=I.model and P.oid=I.processdefinition" + " INNER JOIN " + schemaPrefix + "model M ON M.oid=P.model" + this.makePartitionJoin(schemaPrefix, partitionId) + " WHERE I.starttime >= " + startDate + " AND I.starttime <= " + endDate + this.makeProcessFilter(process);
    }

    private String makePartitionJoin(String schemaPrefix, String partitionId) {
        return StringUtils.isEmpty((String)partitionId) ? "" : " INNER JOIN " + schemaPrefix + "partition R ON R.oid=M.partition and R.id='" + partitionId + "'";
    }

    private String makeProcessFilter(ProcessDefinitionType process) {
        return " AND ( P.id='" + process.getId() + "'" + " AND M.id='" + ModelUtils.findContainingModel((EObject)process).getId() + "')";
    }

    @Override
    public IntervalList execute(DatabaseFacade database) {
        IntervalList result = new IntervalList();
        try {
            ResultSet rs = database.executeQuery(this.sql);
            if (rs != null) {
                while (rs.next()) {
                    result.add(new Interval(rs.getLong(1), 0L));
                }
            }
            database.dispose(rs);
        }
        catch (SQLException e) {
            throw new SimulationFailedException(Simulation_Modeling_Messages.AUDITTRAIL_ERR_SQL, e);
        }
        return result;
    }

    @Override
    public String getObjectHint() {
        return this.objectHint;
    }

    @Override
    public String getSql() {
        return this.sql;
    }
}

