/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.audittrail.ActivityTerminationAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.ArrivalRateAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DurationAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.OccurrenceAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.TransitionAuditTrailQuery;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;

public class AuditTrailQueryFactoryForEMF {
    static final boolean USE_TRANSITION_WORKAROUND = false;
    Date startOfRetrievalRange;
    Date endOfRetrievalRange;
    String schemaPrefix;
    String partitionId;

    public AuditTrailQueryFactoryForEMF(Date startOfRetrievalRange, Date endOfRetrievalRange, String schema, String partitionId) {
        this.startOfRetrievalRange = startOfRetrievalRange;
        this.endOfRetrievalRange = endOfRetrievalRange;
        this.schemaPrefix = schema != null ? String.valueOf(schema) + "." : "";
        this.partitionId = partitionId;
    }

    public IAuditTrailQuery createOccurrenceQuery(ProcessDefinitionType element) {
        return new ArrivalRateAuditTrailQuery(element.getId(), element, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createDurationQuery(ActivityType element) {
        return new DurationAuditTrailQuery(element.getId(), element, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createDurationQuery(ApplicationType element) {
        ActivityType[] concernedActivities = (ActivityType[])element.getExecutedActivities().toArray((Object[])new ActivityType[0]);
        return new DurationAuditTrailQuery(element.getId(), concernedActivities, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createOccurrenceQuery(ApplicationType element) {
        ActivityType[] concernedActivities = (ActivityType[])element.getExecutedActivities().toArray((Object[])new ActivityType[0]);
        return new OccurrenceAuditTrailQuery(element.getId(), concernedActivities, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createOccurrenceQuery(IModelParticipant element) {
        ActivityType[] concernedActivities = (ActivityType[])element.getPerformedActivities().toArray((Object[])new ActivityType[0]);
        return new OccurrenceAuditTrailQuery(element.getId(), concernedActivities, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createAppearanceQuery(TransitionType element) {
        return new TransitionAuditTrailQuery(element.getId(), element, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createTerminationQuery(ActivityType element) {
        return new ActivityTerminationAuditTrailQuery(element.getId(), element, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }

    public IAuditTrailQuery createOccurrenceQuery(ActivityType element) {
        return new OccurrenceAuditTrailQuery(element.getId(), element, this.startOfRetrievalRange.getTime(), this.endOfRetrievalRange.getTime(), this.schemaPrefix, this.partitionId);
    }
}

