/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DatabaseFacade;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.IntervalList;
import org.eclipse.stardust.ide.simulation.ui.validation.SimulationFailedException;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class DurationAuditTrailQuery
implements IAuditTrailQuery {
    String sql;
    String objectHint;

    protected DurationAuditTrailQuery(String objectHint, ActivityType[] activities, long startDate, long endDate, String schemaPrefix, String partitionId) {
        this.objectHint = objectHint;
        this.sql = "SELECT H.fromtimestamp, H.untiltimestamp-H.fromtimestamp FROM " + schemaPrefix + "activity_instance I" + " INNER JOIN " + schemaPrefix + "activity A ON A.model=I.model and A.oid=I.activity" + " INNER JOIN " + schemaPrefix + "process_definition P ON P.model=A.model and P.oid=A.processdefinition" + " INNER JOIN " + schemaPrefix + "model M ON M.oid=P.model" + this.makePartitionJoin(schemaPrefix, partitionId) + " INNER JOIN " + schemaPrefix + "act_inst_history H ON H.activityinstance=I.oid and H.state = " + 1 + " WHERE I.state=" + 2 + " AND I.starttime >= " + startDate + " AND I.starttime <= " + endDate;
        if (activities.length > 0) {
            this.sql = String.valueOf(this.sql) + " AND (" + this.makeActiviteFilter(activities[0]);
            int i = 1;
            while (i < activities.length) {
                this.sql = String.valueOf(this.sql) + " OR " + this.makeActiviteFilter(activities[i]);
                ++i;
            }
            this.sql = String.valueOf(this.sql) + " )";
        }
        this.sql = String.valueOf(this.sql) + " ORDER BY H.fromtimestamp";
    }

    protected DurationAuditTrailQuery(String objectHint, ActivityType activitiy, long startDate, long endDate, String schemaPrefix, String partitionId) {
        this(objectHint, new ActivityType[]{activitiy}, startDate, endDate, schemaPrefix, partitionId);
    }

    private String makePartitionJoin(String schemaPrefix, String partitionId) {
        return StringUtils.isEmpty((String)partitionId) ? "" : " INNER JOIN " + schemaPrefix + "partition R ON R.oid=M.partition and R.id='" + partitionId + "'";
    }

    private String makeActiviteFilter(ActivityType activity) {
        return "( A.id='" + activity.getId() + "'" + " AND P.id='" + ModelUtils.findContainingProcess((EObject)activity).getId() + "'" + " AND M.id='" + ModelUtils.findContainingModel((EObject)activity).getId() + "')";
    }

    @Override
    public IntervalList execute(DatabaseFacade database) {
        IntervalList result = new IntervalList();
        try {
            ResultSet rs = database.executeQuery(this.sql);
            if (rs != null) {
                while (rs.next()) {
                    long startTime = rs.getLong(1);
                    long duration = rs.getLong(2);
                    result.add(new Interval(startTime, duration));
                }
            }
            database.dispose(rs);
        }
        catch (SQLException e) {
            throw new SimulationFailedException(Simulation_Modeling_Messages.AUDITTRAIL_ERR_SQL, e);
        }
        return result;
    }

    @Override
    public String getObjectHint() {
        return this.objectHint;
    }

    @Override
    public String getSql() {
        return this.sql;
    }
}

