/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DatabaseFacade;
import org.eclipse.stardust.ide.simulation.ui.audittrail.DurationAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.IntervalList;
import org.eclipse.stardust.ide.simulation.ui.validation.SimulationFailedException;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;

public class OccurrenceAuditTrailQuery
extends DurationAuditTrailQuery {
    protected OccurrenceAuditTrailQuery(String objectHint, ActivityType[] activities, long startDate, long endDate, String schemaPrefix, String partitionId) {
        super(objectHint, activities, startDate, endDate, schemaPrefix, partitionId);
    }

    protected OccurrenceAuditTrailQuery(String objectHint, ActivityType activity, long startDate, long endDate, String schemaPrefix, String partitionId) {
        super(objectHint, activity, startDate, endDate, schemaPrefix, partitionId);
    }

    @Override
    public IntervalList execute(DatabaseFacade database) {
        IntervalList result = new IntervalList();
        try {
            ResultSet rs = database.executeQuery(this.sql);
            if (rs != null) {
                HashMap<String, Long> started = new HashMap<String, Long>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    int type = rs.getInt(2);
                    if (type == 1) {
                        started.put(id, new Long(rs.getLong(3)));
                        continue;
                    }
                    if (type != 2 && type != 3 || !started.containsKey(id)) continue;
                    long startTime = (Long)started.get(id);
                    long endTime = rs.getLong(3);
                    result.add(new Interval(startTime, endTime - startTime));
                    started.remove(id);
                }
            }
            database.dispose(rs);
        }
        catch (SQLException e) {
            throw new SimulationFailedException(Simulation_Modeling_Messages.AUDITTRAIL_ERR_SQL, e);
        }
        return result;
    }
}

