/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.commongui;

import org.eclipse.stardust.ide.simulation.ui.commongui.VerificationStatusHandler;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class VerifyFormatBase
implements VerifyListener,
FocusListener {
    VerificationStatusHandler errorHandler;

    public VerifyFormatBase() {
        this.errorHandler = null;
    }

    public VerifyFormatBase(VerificationStatusHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void verifyText(VerifyEvent e) {
        String newText = this.getNewValue(((Text)e.widget).getText(), e.start, e.end, e.text);
        e.doit = this.verifyTextImpl(newText);
    }

    public boolean verifyText(String newText) {
        return this.verifyTextImpl(newText) && this.isReady(newText);
    }

    protected boolean verifyTextImpl(String newText) {
        boolean valid = this.isValid(newText);
        if (valid & this.errorHandler != null) {
            if (this.isReady(newText)) {
                this.errorHandler.onValidValue(newText);
            } else {
                this.errorHandler.onInvalidValue(newText);
            }
        }
        return valid;
    }

    protected String getNewValue(String old, int start, int end, String text) {
        return String.valueOf(old.substring(0, start)) + text + old.substring(end);
    }

    protected boolean isValid(String text) {
        return true;
    }

    protected boolean isReady(String text) {
        return true;
    }

    protected String completeFormat(String text) {
        return text;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Text text = (Text)e.widget;
        if (this.isValid(text.getText()) && this.isReady(text.getText())) {
            text.setText(this.completeFormat(text.getText()));
        } else {
            text.forceFocus();
        }
    }
}

