/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public interface IResourceReader {
    public List read(InputStream var1) throws IOException;

    public static class CsvReader
    implements IResourceReader {
        static final String COMMENT_CHAR = "#";
        static final String ENCODING_KEY = "!encoding=";

        @Override
        public List read(InputStream stream) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            if (line != null) {
                if (line.startsWith(ENCODING_KEY)) {
                    reader = new BufferedReader(new InputStreamReader(stream, line.substring(ENCODING_KEY.length())));
                } else if (!line.startsWith(COMMENT_CHAR)) {
                    result.add(line);
                }
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(COMMENT_CHAR)) continue;
                    result.add(line);
                }
            }
            return result;
        }
    }
}

