/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Random;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;

public abstract class NormalDistributionDataGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_NORMAL_RANDOM_DOUBLE0;
    public static final String OPTION_SIGMA = "sigma";
    public static final String OPTION_MJU = "mju";
    Random random = new Random(System.currentTimeMillis());

    public NormalDistributionDataGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_MJU, "0");
        this.options.put(OPTION_SIGMA, "1");
    }

    protected Double getRandomImpl() {
        return new Double(this.random.nextGaussian() * this.getSigma() + this.getMju());
    }

    private double getMju() {
        return Double.parseDouble(this.getOption(OPTION_MJU));
    }

    private double getSigmaSqr() {
        return Double.parseDouble(this.getOption(OPTION_SIGMA));
    }

    private double getSigma() {
        return Math.sqrt(this.getSigmaSqr());
    }

    @Override
    public boolean isComplete() {
        try {
            this.getMju();
            return this.getSigma() > 0.0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

