/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerificationStatusHandler;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleMinMax;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.Range;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.NormalDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DefaultDynamicAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.GuaranteeVisibility;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.PCentLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NormalDistributionDataGeneratorPanel
extends RandomDataGeneratorPanel {
    LabeledText mju = FormBuilder.createLabeledText((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.MJU);
    LabeledText sigmaSqr;
    Canvas canvas;
    WrapperLayer curve;

    protected NormalDistributionDataGeneratorPanel(Composite parent, NormalDistributionDataGenerator configuration) {
        super(parent, configuration);
        this.mju.getText().setText(configuration.getOption("mju"));
        this.mju.getText().addVerifyListener((VerifyListener)new VerifyDoubleMinMax(-999999.0, 999999.0, new VerificationStatusHandler(){

            @Override
            public void onInvalidValue(String s) {
                NormalDistributionDataGeneratorPanel.this.mju.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                NormalDistributionDataGeneratorPanel.this.mju.getLabel().setToolTipText(Simulation_Modeling_Messages.ERROR_VALUE_OUTSIDE_OF_RANGE);
            }

            @Override
            public void onValidValue(String s) {
                NormalDistributionDataGeneratorPanel.this.mju.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                NormalDistributionDataGeneratorPanel.this.mju.getLabel().setToolTipText("");
            }
        }));
        this.sigmaSqr = FormBuilder.createLabeledText((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.SIGMA);
        this.sigmaSqr.getText().setText(configuration.getOption("sigma"));
        this.sigmaSqr.getText().addVerifyListener((VerifyListener)new VerifyDoubleMinMax(0.0, 999999.0, new VerificationStatusHandler(){

            @Override
            public void onInvalidValue(String s) {
                NormalDistributionDataGeneratorPanel.this.sigmaSqr.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                NormalDistributionDataGeneratorPanel.this.sigmaSqr.getLabel().setToolTipText(Simulation_Modeling_Messages.ERROR_VALUE_OUTSIDE_OF_RANGE);
            }

            @Override
            public void onValidValue(String s) {
                NormalDistributionDataGeneratorPanel.this.sigmaSqr.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                NormalDistributionDataGeneratorPanel.this.sigmaSqr.getLabel().setToolTipText("");
            }
        }));
        this.initAdditionalControls();
        this.canvas = new Canvas(this.getInnerBody(), 2048);
        this.canvas.setBackground(ColorConstants.listBackground);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.canvas);
        Drawing drawing = new Drawing(Configuration.createDefault());
        this.curve = new WrapperLayer();
        drawing.addLayer((Layer)this.curve);
        drawing.addLayer((Layer)new XAxisLayer("x", null, (AxisLabeling)new DefaultDynamicAxisLabeling(), true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        this.canvas.addPaintListener((PaintListener)drawing);
        ModifyListener redrawOnModification = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NormalDistributionDataGeneratorPanel.this.updateCurve();
            }
        };
        this.mju.getText().addModifyListener(redrawOnModification);
        this.sigmaSqr.getText().addModifyListener(redrawOnModification);
        this.updateCurve();
    }

    protected void initAdditionalControls() {
    }

    @Override
    protected void syncUiToModel() {
        this.configuration.getOptions().put("mju", this.mju.getText().getText());
        this.configuration.getOptions().put("sigma", this.sigmaSqr.getText().getText());
        super.syncUiToModel();
    }

    protected void updateCurve() {
        if (this.mju.getLabel().getValidationStatus() == IQuickValidationStatus.OK && this.sigmaSqr.getLabel().getValidationStatus() == IQuickValidationStatus.OK) {
            double mjuValue = Double.parseDouble(this.mju.getText().getText());
            double sigmaSqrValue = Double.parseDouble(this.sigmaSqr.getText().getText());
            double resolution = sigmaSqrValue > 1.0 ? 0.1 : 0.01;
            NormalDistribution f = new NormalDistribution(mjuValue, sigmaSqrValue);
            DynamicRange range = new DynamicRange((DataProviderForDoubleFunction.Function)f, resolution, 0.001 * f.f(mjuValue), mjuValue);
            this.curve.setDelegate((Layer)new StrokedCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0));
            this.canvas.redraw();
        }
    }
}

