/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerificationStatusHandler;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleMinMax;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.PositiveRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.Range;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.PoissonDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DefaultDynamicAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.GuaranteeVisibility;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.PCentLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.datagen.PoissonDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PoissonDistributionDataGeneratorPanel
extends RandomDataGeneratorPanel {
    private static final String[] multiplicatorSuggestions = new String[]{"1", "10", "100", "1000", "100000", "1000000"};
    private static final NumberFormat formatter = new DecimalFormat(" #,###,###");
    LabeledText lambda = FormBuilder.createLabeledText((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.LAMBDA);
    LabeledCombo multiplicator;
    Canvas canvas;
    WrapperLayer curve;

    protected PoissonDistributionDataGeneratorPanel(Composite parent, PoissonDistributionDataGenerator configuration) {
        super(parent, configuration);
        this.lambda.getText().setText(configuration.getOption("lambda"));
        this.lambda.getText().addVerifyListener((VerifyListener)new VerifyDoubleMinMax(0.1, 100.0, new VerificationStatusHandler(){

            @Override
            public void onInvalidValue(String s) {
                PoissonDistributionDataGeneratorPanel.this.lambda.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                PoissonDistributionDataGeneratorPanel.this.lambda.getLabel().setToolTipText(Simulation_Modeling_Messages.ERROR_VALUE_OUTSIDE_OF_RANGE);
            }

            @Override
            public void onValidValue(String s) {
                PoissonDistributionDataGeneratorPanel.this.lambda.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                PoissonDistributionDataGeneratorPanel.this.lambda.getLabel().setToolTipText("");
            }
        }));
        this.multiplicator = FormBuilder.createLabeledCombo((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.DATA_VALUE_GENERATOR_MULTIPLICATOR);
        this.multiplicator.getCombo().setItems(multiplicatorSuggestions);
        int i = 0;
        while (i < multiplicatorSuggestions.length) {
            String formatted = formatter.format(Double.parseDouble(multiplicatorSuggestions[i]));
            this.multiplicator.getCombo().setItem(i, formatted);
            ++i;
        }
        String selection = configuration.getOption("multiplicator");
        int selectionIndex = Arrays.asList(multiplicatorSuggestions).indexOf(selection);
        this.multiplicator.getCombo().select(selectionIndex > 0 ? selectionIndex : 0);
        this.initAdditionalControls();
        this.canvas = new Canvas(this.getInnerBody(), 2048);
        this.canvas.setBackground(ColorConstants.listBackground);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.canvas);
        Drawing drawing = new Drawing(Configuration.createDefault());
        this.curve = new WrapperLayer();
        drawing.addLayer((Layer)this.curve);
        drawing.addLayer((Layer)new XAxisLayer("x", null, (AxisLabeling)new DefaultDynamicAxisLabeling(), true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        this.canvas.addPaintListener((PaintListener)drawing);
        ModifyListener redrawOnModification = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PoissonDistributionDataGeneratorPanel.this.updateCurve();
            }
        };
        this.lambda.getText().addModifyListener(redrawOnModification);
        this.updateCurve();
    }

    protected void initAdditionalControls() {
    }

    @Override
    protected void syncUiToModel() {
        this.configuration.getOptions().put("lambda", this.lambda.getText().getText());
        int selectionIndex = this.multiplicator.getCombo().getSelectionIndex();
        this.configuration.getOptions().put("multiplicator", multiplicatorSuggestions[selectionIndex > 0 ? selectionIndex : 0]);
        super.syncUiToModel();
    }

    protected void updateCurve() {
        if (this.lambda.getLabel().getValidationStatus() == IQuickValidationStatus.OK) {
            double lambdaValue = Math.max(0.1, Double.parseDouble(this.lambda.getText().getText()));
            PoissonDistribution f = new PoissonDistribution(lambdaValue);
            PositiveRange range = new PositiveRange((Range)new DynamicRange((DataProviderForDoubleFunction.Function)f, 1.0, 0.001 * f.f(lambdaValue), lambdaValue));
            this.curve.setDelegate((Layer)new StrokedCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0));
            this.canvas.redraw();
        }
    }
}

