/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableMultiplicator;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AvailabilityCalendarUtility;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.standardholidays.NoHolidays;
import org.eclipse.stardust.ide.simulation.ui.timeutils.standardholidays.SaturdayHolidays;
import org.eclipse.stardust.ide.simulation.ui.timeutils.standardholidays.SundayHolidays;

public class AvailabilityConfiguration
extends AbstractRetrievableSimulationSubConfiguration {
    private static final String DEFAULT_DAY_STRING = "msec:[0;0.0][28800000;1.0][57600000;0.0][86400000;0.0]";
    private static final String DEFAULT_CALENDAR_STRING = null;
    private static final String DEFAULT_YEAR_STRING = "msec:[0;1.0][@enddate@;1.0]";
    private static final String DEFAULT_PREDEFINED_STRING = String.valueOf(SaturdayHolidays.class.getName()) + ";" + SundayHolidays.class.getName();
    public static final String EMPTY_CALENDAR_BASE = NoHolidays.class.getName();
    private List day = new ArrayList();
    private List calendar = new ArrayList();
    private List year = new ArrayList();
    private List predefined;
    private AdjustableMultiplicator multiplicator = new AdjustableMultiplicator("availability");
    private boolean unlimited = true;

    public AvailabilityConfiguration(SimulationInterval interval) {
        super(interval);
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            super.read(attributes);
            String unlimitedString = attributes.getAttibute("availability:unlimited", Boolean.toString(this.unlimited));
            this.unlimited = Boolean.valueOf(unlimitedString);
            String dayString = attributes.getAttibute("availability:day", DEFAULT_DAY_STRING);
            dayString = this.stripUnit(dayString);
            TimestampValue.stringToList(this.day, dayString);
            String calendarString = attributes.getAttibute("availability:calendar", DEFAULT_CALENDAR_STRING);
            if (calendarString == null) {
                if (this.interval != null) {
                    this.calendar.addAll(AvailabilityCalendarUtility.createAvailabilityCalendar(this.interval.getStartDate(), this.interval.getEndDate()));
                }
            } else {
                calendarString = this.stripUnit(calendarString);
                TimestampValue.stringToList(this.calendar, calendarString);
            }
            String yearString = attributes.getAttibute("availability:year", DEFAULT_YEAR_STRING.replaceAll("@enddate@", Long.toString(this.interval.getDurationInMillis())));
            yearString = this.stripUnit(yearString);
            TimestampValue.stringToList(this.year, yearString);
            String predefinedString = attributes.getAttibute("availability:calendarbase", DEFAULT_PREDEFINED_STRING);
            this.predefined = Arrays.asList(predefinedString.split(";", -1));
            for (String listName : this.predefined) {
                AvailabilityCalendarUtility.addToAvailabilityCalendar(this.interval.getStartDate(), this.calendar, listName);
            }
            AvailabilityCalendarUtility.unmarkUncommonWorkdays(this.calendar);
            this.multiplicator.read(attributes);
        }
        catch (RuntimeException e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        super.write(attributes);
        attributes.setAttibute("availability:unlimited", Boolean.toString(this.unlimited));
        if (!this.unlimited) {
            AvailabilityCalendarUtility.markUncommonWorkdays(this.interval.getStartDate(), this.calendar, this.predefined);
            attributes.setAttibute("availability:day", "msec:" + TimestampValue.listToString(this.day));
            attributes.setAttibute("availability:calendar", "msec:" + TimestampValue.listToString(this.calendar));
            attributes.setAttibute("availability:year", "msec:" + TimestampValue.listToString(this.year));
            if (this.predefined.size() == 0) {
                attributes.setAttibute("availability:calendarbase", EMPTY_CALENDAR_BASE);
            } else {
                attributes.setAttibute("availability:calendarbase", AvailabilityConfiguration.createCSV(this.predefined, ";"));
            }
            this.multiplicator.write(attributes);
        }
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public void setDay(TimestampValue[] availability) {
        this.day.clear();
        this.day.addAll(Arrays.asList(availability));
    }

    public List getDay() {
        return this.day;
    }

    public void setCalendar(TimestampValue[] availability) {
        this.calendar.clear();
        this.calendar.addAll(Arrays.asList(availability));
    }

    public List getCalendar() {
        this.calendar = this.verifySymulationInterval(this.calendar, true);
        return this.calendar;
    }

    public void setYear(TimestampValue[] availability) {
        this.year.clear();
        this.year.addAll(Arrays.asList(availability));
    }

    public List getYear() {
        this.year = this.verifySymulationInterval(this.year, false);
        return this.year;
    }

    public String[] getPredefinedCalendars() {
        return this.predefined.toArray(new String[this.predefined.size()]);
    }

    public void setPredefinedCalendars(String[] predefined) {
        this.predefined = new ArrayList<String>(Arrays.asList(predefined));
    }

    public void setMultiplicatorSlider(AdjustableDoubleRange slider) {
        this.multiplicator.setRange(slider);
    }

    public AdjustableMultiplicator getMultiplicator() {
        return this.multiplicator;
    }

    public List getMultiplicatorCurve() {
        double multiplicator = this.getMultiplicator().getValue();
        LinkedList<TimestampValue> result = new LinkedList<TimestampValue>();
        result.add(new TimestampValue(0L, multiplicator));
        result.add(new TimestampValue(this.getInterval().getDurationInMillis(), multiplicator));
        return result;
    }

    public AdjustableDoubleRange getMultiplicatorSlider() {
        return this.multiplicator.getRange();
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return new AdjustableValue[]{this.multiplicator};
    }

    private String stripUnit(String string) {
        return string.startsWith("msec:") ? string.substring(5) : string;
    }

    private static String createCSV(List list, String separator) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append((String)iter.next());
        }
        return sb.toString();
    }

    private List verifySymulationInterval(List list, boolean dailyCurve) {
        ArrayList<TimestampValue> result = new ArrayList<TimestampValue>();
        long offset = this.getInterval().getStartDate().getTime();
        TimeCalculator end = new TimeCalculator(this.getInterval().getEndDate()).moveToBeginOfDay().add(6, 1);
        if (list.size() > 0) {
            TimestampValue last = (TimestampValue)list.get(list.size() - 1);
            TimeCalculator lastTC = new TimeCalculator(last.shift(offset));
            if (lastTC.after(end)) {
                int i = 0;
                while (i < list.size()) {
                    TimestampValue current = (TimestampValue)list.get(i);
                    TimeCalculator currentTC = new TimeCalculator(current.shift(offset));
                    if (currentTC.before(end)) {
                        result.add(current);
                    }
                    ++i;
                }
                result.add(new TimestampValue(end.toLong() - offset, last.getValue()));
                return result;
            }
            if (lastTC.before(end)) {
                result.addAll(list);
                if (dailyCurve) {
                    TimeCalculator nextTC = lastTC.add(6, 1);
                    while (!nextTC.after(end)) {
                        result.add(new TimestampValue(nextTC.toLong() - offset, 0.0));
                        nextTC = nextTC.add(6, 1);
                    }
                } else {
                    result.add(new TimestampValue(end.toLong() - offset, 0.0));
                }
                return result;
            }
        }
        return list;
    }

    @Override
    protected String getFromAuditTrailAttributeName() {
        return "availability:fromAuditTrail";
    }

    @Override
    public boolean isComplete() {
        return !this.isNull();
    }
}

