/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.BooleanGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.CharacterGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDoubleGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionIntegerGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.NullDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.PoissonDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.ResourceFileCalendarGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.ResourceFileLongGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.ResourceFileStringGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.TimestampCalendarGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.TimestampLongGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionDoubleGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionIntegerGenerator;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;

public class DataValueGeneratorConfiguration
extends AbstractRetrievableSimulationSubConfiguration {
    String dataTypeClassId;
    RandomDataGenerator generator;

    public DataValueGeneratorConfiguration(SimulationInterval simulationInterval) {
        super(simulationInterval);
    }

    public String getDataTypeClassId() {
        return this.dataTypeClassId;
    }

    public void setDataTypeClassId(String dataTypeClassId) {
        this.dataTypeClassId = dataTypeClassId;
    }

    public RandomDataGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(RandomDataGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        super.read(attributes);
        this.dataTypeClassId = attributes.getAttibute("datavalue:dataType", this.dataTypeClassId);
        String generatorClass = attributes.getAttibute("datavalue:generator", NullDataGenerator.class.getName());
        if (generatorClass != null) {
            this.setGenerator(this.createGenerator(generatorClass));
            this.generator.read(attributes);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        super.write(attributes);
        attributes.setAttibute("datavalue:dataType", this.dataTypeClassId);
        if (this.generator != null) {
            attributes.setAttibute("datavalue:generator", this.generator.getClass().getName());
            this.generator.write(attributes);
        } else {
            attributes.setAttibute("datavalue:generator", null);
        }
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return this.generator != null ? this.generator.getBoundValues() : null;
    }

    public void verifyDataTypeClass(String dataTypeClassId) {
        if (this.dataTypeClassId == null || !this.dataTypeClassId.equals(dataTypeClassId)) {
            System.out.println("WARNING: DataType type changed. Old Configuration is not valid.");
            System.out.println("         " + this.dataTypeClassId + " != " + dataTypeClassId);
            this.setDataTypeClassId(dataTypeClassId);
            try {
                String defaultGeneratorClass = this.getAvailableGeneratorClasses()[0];
                boolean showInfo = !this.getGenerator().getClass().getName().equals(defaultGeneratorClass);
                this.setGenerator(this.createGenerator(defaultGeneratorClass));
                if (showInfo) {
                    SimulationPlugin.getDefault().getLog().log((IStatus)new Status(1, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_DATAGENERATOR_RESETED_INFO, null));
                }
            }
            catch (RuntimeException e) {
                SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_DATAGENERATOR_RESETED_WARN, (Throwable)e));
            }
        }
    }

    public String[] getAvailableGeneratorClasses() {
        if ("Calendar".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), TimestampCalendarGenerator.class.getName(), ResourceFileCalendarGenerator.class.getName()};
        }
        if ("String".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), ResourceFileStringGenerator.class.getName()};
        }
        if ("text".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), ResourceFileStringGenerator.class.getName()};
        }
        if ("Timestamp".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionDoubleGenerator.class.getName(), UniformDistributionDoubleGenerator.class.getName(), TimestampLongGenerator.class.getName(), ResourceFileLongGenerator.class.getName()};
        }
        if ("boolean".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), BooleanGenerator.class.getName()};
        }
        if ("byte".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionIntegerGenerator.class.getName(), PoissonDistributionDataGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        if ("char".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), CharacterGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        if ("double".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionDoubleGenerator.class.getName(), UniformDistributionDoubleGenerator.class.getName()};
        }
        if ("float".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionDoubleGenerator.class.getName(), UniformDistributionDoubleGenerator.class.getName()};
        }
        if ("int".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionIntegerGenerator.class.getName(), PoissonDistributionDataGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        if ("long".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionIntegerGenerator.class.getName(), PoissonDistributionDataGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        if ("short".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionIntegerGenerator.class.getName(), PoissonDistributionDataGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        if ("numeric".equals(this.getDataTypeClassId())) {
            return new String[]{NullDataGenerator.class.getName(), NormalDistributionIntegerGenerator.class.getName(), PoissonDistributionDataGenerator.class.getName(), UniformDistributionIntegerGenerator.class.getName()};
        }
        return new String[]{NullDataGenerator.class.getName()};
    }

    public String getGeneratorName(String id) {
        try {
            return (String)Class.forName(id).getField("NAME").get(null);
        }
        catch (Exception exception) {
            return id;
        }
    }

    public String getGeneratorId(String name) {
        try {
            String[] availableClasses = this.getAvailableGeneratorClasses();
            int i = 0;
            while (i < availableClasses.length) {
                String aName = (String)Class.forName(availableClasses[i]).getField("NAME").get(null);
                if (name.equals(aName)) {
                    return availableClasses[i];
                }
                ++i;
            }
            return name;
        }
        catch (Exception exception) {
            return name;
        }
    }

    public RandomDataGenerator createGenerator(String id) {
        try {
            return (RandomDataGenerator)Class.forName(id).getConstructor(SimulationInterval.class).newInstance(this.getInterval());
        }
        catch (Exception e) {
            SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_DATAGENERATOR_RESETED_WARN, (Throwable)e));
            return new NullDataGenerator(this.getInterval());
        }
    }

    @Override
    protected String getFromAuditTrailAttributeName() {
        return "data:fromAuditTrail";
    }

    @Override
    public boolean isComplete() {
        return !this.isNull() && this.generator != null && this.generator.isComplete();
    }

    public static String retrieveDataTypeClass(DataType dataType) {
        AttributeType typeAttribute = AttributeUtil.getAttribute((IExtensibleElement)dataType, (String)"carnot:engine:type");
        if (typeAttribute != null) {
            return typeAttribute.getValue();
        }
        AttributeType typeHintAttribute = AttributeUtil.getAttribute((IExtensibleElement)dataType, (String)"carnot:engine:typeHint");
        if (typeHintAttribute == null || "text".equals(typeHintAttribute.getValue())) {
            return "text";
        }
        if ("numeric".equals(typeHintAttribute.getValue())) {
            return "numeric";
        }
        return null;
    }

    public static AttributeType getTypeAttribute(IExtensibleElement element) {
        AttributeType typeAttribute = AttributeUtil.getAttribute((IExtensibleElement)element, (String)"carnot:engine:type");
        if (typeAttribute != null) {
            return typeAttribute;
        }
        AttributeType typeHintAttribute = AttributeUtil.getAttribute((IExtensibleElement)element, (String)"carnot:engine:typeHint");
        if (typeHintAttribute != null) {
            return typeHintAttribute;
        }
        return null;
    }
}

