/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import java.util.HashMap;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.CustomDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.NormalDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.PoissonDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.UniformDistributionConfiguration;

public class DistributionFactory {
    public static final String NORMAL_DISTRIBUTION_ID = "1001";
    public static final String POISSON_DISTRIBUTION_ID = "1002";
    public static final String UNIFORM_DISTRIBUTION_ID = "1003";
    public static final String CUSTOM_DISTRIBUTION_ID = "1004";
    private HashMap distributionsMap = new HashMap();
    private SimulationInterval interval;

    public DistributionFactory(SimulationInterval interval) {
        this.interval = interval;
        this.distributionsMap.put(NORMAL_DISTRIBUTION_ID, Simulation_Modeling_Messages.NORMAL_DISTRIBUTION);
        this.distributionsMap.put(POISSON_DISTRIBUTION_ID, Simulation_Modeling_Messages.POISSON_DISTRIBUTION);
        this.distributionsMap.put(UNIFORM_DISTRIBUTION_ID, Simulation_Modeling_Messages.UNIFORM_DISTRIBUTION);
        this.distributionsMap.put(CUSTOM_DISTRIBUTION_ID, Simulation_Modeling_Messages.CUSTOM_DISTRIBUTION);
    }

    public IDistributionConfiguration create(String distributionTypeId) {
        if (distributionTypeId.equals(NORMAL_DISTRIBUTION_ID)) {
            return new NormalDistributionConfiguration(this.interval);
        }
        if (distributionTypeId.equals(POISSON_DISTRIBUTION_ID)) {
            return new PoissonDistributionConfiguration(this.interval);
        }
        if (distributionTypeId.equals(UNIFORM_DISTRIBUTION_ID)) {
            return new UniformDistributionConfiguration(this.interval);
        }
        if (distributionTypeId.equals(CUSTOM_DISTRIBUTION_ID)) {
            return new CustomDistributionConfiguration(this.interval);
        }
        throw new RuntimeException("Distribution <" + distributionTypeId + "> is not allowed!");
    }

    public String getNameById(String id) {
        return (String)this.distributionsMap.get(id);
    }

    public String getIdByName(String distribution) {
        for (String key : this.distributionsMap.keySet()) {
            if (!this.distributionsMap.get(key).equals(distribution)) continue;
            return key;
        }
        return null;
    }

    public static String getDistributionNameById(String id) {
        return new DistributionFactory(null).getNameById(id);
    }

    public static String getDistributionIdByName(String distribution) {
        return new DistributionFactory(null).getIdByName(distribution);
    }
}

