/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDouble;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;

public class NormalDistributionConfiguration
extends AbstractSimulationSubConfiguration
implements IDistributionConfiguration {
    private AdjustableDouble mju = new AdjustableDouble(this.getFullAttributName("distribution:mju"));
    private AdjustableDouble sigmasqr = new AdjustableDouble(this.getFullAttributName("distribution:sigma"));

    public NormalDistributionConfiguration(SimulationInterval interval) {
        super(interval);
    }

    public AdjustableDouble getMju() {
        return this.mju;
    }

    public AdjustableDouble getSigmaSqr() {
        return this.sigmasqr;
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            this.mju.read(attributes);
            this.sigmasqr.read(attributes);
        }
        catch (Exception e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        this.mju.write(attributes);
        this.sigmasqr.write(attributes);
    }

    @Override
    public String getDistributionTypeId() {
        return "1001";
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return new AdjustableValue[]{this.mju, this.sigmasqr};
    }

    protected String getFullAttributName(String attributName) {
        return DistributionUtils.getFullAttributName(this.getDistributionTypeId(), attributName);
    }

    @Override
    public boolean isComplete() {
        return !this.isNull();
    }
}

