/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.PoissonDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableMultiplicator;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class ProbabilityConfiguration
extends AbstractRetrievableSimulationSubConfiguration {
    private static final String DEFAULT_YEAR_STRING = "msec:[0;@probability@][@enddate@;@probability@]";
    private List curve = new ArrayList();
    private AdjustableMultiplicator multiplicator;
    private double defaultProbability;
    private IDistributionConfiguration repetitionDistribution;

    public ProbabilityConfiguration(SimulationInterval interval, double defaultProbability) {
        super(interval);
        this.defaultProbability = defaultProbability;
        this.multiplicator = new AdjustableMultiplicator("probability");
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            super.read(attributes);
            boolean uninitialized = attributes.getAttibute("probability:curve", null) == null && attributes.getAttibute("distribution:type", null) == null;
            String curveString = attributes.getAttibute("probability:curve", DEFAULT_YEAR_STRING.replaceAll("@enddate@", Long.toString(this.interval.getDurationInMillis())).replaceAll("@probability@", Double.toString(this.defaultProbability)));
            curveString = this.stripUnit(curveString);
            TimestampValue.stringToList(this.curve, curveString);
            this.multiplicator.read(attributes);
            if (uninitialized) {
                DistributionFactory distributionFactory = new DistributionFactory(this.interval);
                this.repetitionDistribution = distributionFactory.create("1002");
                ((PoissonDistributionConfiguration)this.repetitionDistribution).getLambda().setValue(10.0);
            } else {
                String distributionTypeId = attributes.getAttibute("distribution:type", DistributionUtils.getDefaultFor("distribution:type"));
                if (distributionTypeId != null) {
                    DistributionFactory distributionFactory = new DistributionFactory(this.interval);
                    this.repetitionDistribution = distributionFactory.create(distributionTypeId);
                    this.repetitionDistribution.read(attributes);
                }
            }
        }
        catch (Exception e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        super.write(attributes);
        attributes.setAttibute("probability:curve", "msec:" + TimestampValue.listToString(this.curve));
        this.multiplicator.write(attributes);
        if (this.repetitionDistribution != null) {
            attributes.setAttibute("distribution:type", this.repetitionDistribution.getDistributionTypeId());
            this.repetitionDistribution.write(attributes);
        } else {
            attributes.setAttibute("distribution:type", null);
        }
    }

    public boolean isAnyValue() {
        return this.curve == null || this.curve.size() > 0;
    }

    public boolean isSimpleValue() {
        return this.curve == null || this.curve.size() <= 2;
    }

    public double getValue() {
        return ((TimestampValue)this.curve.get(0)).getValue();
    }

    public void setCurve(TimestampValue[] probability) {
        this.curve.clear();
        this.curve.addAll(Arrays.asList(probability));
    }

    public List getCurve() {
        return this.curve;
    }

    public void setEndPoint(long timestamp) {
        if (this.curve.size() > 0) {
            TimestampValue endOfTime = (TimestampValue)this.curve.get(this.curve.size() - 1);
            this.curve.set(this.curve.size() - 1, new TimestampValue(timestamp, endOfTime.getValue()));
        } else {
            this.curve.add(new TimestampValue(timestamp, 0.0));
        }
    }

    public void setMultiplicatorSlider(AdjustableDoubleRange slider) {
        this.multiplicator.setRange(slider);
    }

    public AdjustableDoubleRange getMultiplicatorSlider() {
        return this.multiplicator.getRange();
    }

    public AdjustableMultiplicator getMultiplicator() {
        return this.multiplicator;
    }

    public List getMultiplicatorCurve() {
        double multiplicator = this.getMultiplicator().getValue();
        LinkedList<TimestampValue> result = new LinkedList<TimestampValue>();
        result.add(new TimestampValue(0L, multiplicator));
        result.add(new TimestampValue(this.getInterval().getDurationInMillis(), multiplicator));
        return result;
    }

    public IDistributionConfiguration getRepetitionDistribution() {
        return this.repetitionDistribution;
    }

    public void setRepetitionDistribution(IDistributionConfiguration repetitionDistribution) {
        this.repetitionDistribution = repetitionDistribution;
    }

    private String stripUnit(String string) {
        return string.startsWith("msec:") ? string.substring(5) : string;
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        if (this.repetitionDistribution == null) {
            return new AdjustableValue[]{this.multiplicator};
        }
        AdjustableValue[] childBoundValues = this.repetitionDistribution.getBoundValues();
        if (childBoundValues == null) {
            return new AdjustableValue[]{this.multiplicator};
        }
        AdjustableValue[] result = new AdjustableValue[childBoundValues.length + 1];
        result[0] = this.multiplicator;
        System.arraycopy(childBoundValues, 0, result, 1, childBoundValues.length);
        return result;
    }

    public static void main(String[] args) {
        int configurationId = 4711;
        SimulationInterval intervalConfiguration = new SimulationInterval(TimeCalculator.now().toDate(), TimeCalculator.fromNow(2, 1).toDate());
        ProbabilityConfiguration ac1 = new ProbabilityConfiguration(intervalConfiguration, 100.0);
        ac1.read(new HashMap(), configurationId);
        LinkedHashMap m1 = new LinkedHashMap();
        ac1.write(m1, configurationId);
        System.out.println("===========================");
        for (String key : m1.keySet()) {
            System.out.println(key + " => " + m1.get(key));
        }
        ProbabilityConfiguration ac2 = new ProbabilityConfiguration(intervalConfiguration, 100.0);
        ac2.read(m1, configurationId);
        LinkedHashMap m2 = new LinkedHashMap();
        ac2.write(m2, configurationId);
        System.out.println("===========================");
        for (String key : m2.keySet()) {
            System.out.println(key + " => " + m2.get(key));
        }
    }

    @Override
    protected String getFromAuditTrailAttributeName() {
        return "probability:fromAuditTrail";
    }

    @Override
    public boolean isComplete() {
        return !this.isNull() && (this.repetitionDistribution == null || this.repetitionDistribution.isComplete());
    }
}

