/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDouble;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;

public class UniformDistributionConfiguration
extends AbstractSimulationSubConfiguration
implements IDistributionConfiguration {
    private AdjustableDouble startPoint = new AdjustableDouble(this.getFullAttributName("distribution:startPoint"));
    private AdjustableDouble endPoint = new AdjustableDouble(this.getFullAttributName("distribution:endPoint"));

    public UniformDistributionConfiguration(SimulationInterval interval) {
        super(interval);
    }

    public AdjustableDouble getEndPoint() {
        return this.endPoint;
    }

    public AdjustableDouble getStartPoint() {
        return this.startPoint;
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            this.startPoint.read(attributes);
            this.endPoint.read(attributes);
        }
        catch (Exception e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        this.startPoint.write(attributes);
        this.endPoint.write(attributes);
    }

    @Override
    public String getDistributionTypeId() {
        return "1003";
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return new AdjustableValue[]{this.startPoint, this.endPoint};
    }

    protected String getFullAttributName(String attributName) {
        return DistributionUtils.getFullAttributName(this.getDistributionTypeId(), attributName);
    }

    @Override
    public boolean isComplete() {
        return !this.isNull();
    }
}

