/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.utils;

import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleDataProvider;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;
import org.eclipse.stardust.ide.simulation.ui.slider.SimSlider;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;

public class AdjustableDouble
implements AdjustableValue {
    String attributeId;
    double value;
    AdjustableDoubleRange range;
    boolean modified = false;

    public AdjustableDouble(String attributeId) {
        this.attributeId = attributeId;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.modified = this.modified || this.value != value;
        this.value = value;
    }

    public AdjustableDoubleRange getRange() {
        return this.range;
    }

    public void setRange(AdjustableDoubleRange range) {
        this.modified = this.modified || this.range != range;
        this.range = range;
    }

    @Override
    public boolean isAdjustable() {
        return this.range != null;
    }

    @Override
    public SimSlider createSlider(IModelElement element, int configurationId) {
        return new SimSlider(element, configurationId, new AdjustableDoubleDataProvider(this));
    }

    public double getStoredValue(AttributeAccessAdapter attributes) {
        String defaultValue = DistributionUtils.getDefaultFor(this.attributeId);
        return Double.parseDouble(attributes.getAttibute(this.attributeId, defaultValue));
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        String defaultValue = DistributionUtils.getDefaultFor(this.attributeId);
        this.setValue(Double.parseDouble(attributes.getAttibute(this.attributeId, defaultValue)));
        String sliderAttribute = attributes.getAttibute(String.valueOf(this.attributeId) + ":slider", null);
        if (sliderAttribute != null) {
            this.range = AdjustableDoubleRange.fromString(sliderAttribute);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        attributes.setAttibute(this.attributeId, Double.toString(this.getValue()));
        if (this.range != null) {
            attributes.setAttibute(String.valueOf(this.attributeId) + ":slider", AdjustableDoubleRange.toString(this.range));
        } else {
            attributes.setAttibute(String.valueOf(this.attributeId) + ":slider", null);
        }
    }

    public boolean isModified() {
        return this.modified;
    }
}

