/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.utils;

import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDouble;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleChangeCommand;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleDeleteCommand;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.slider.SimSliderDataProvider;

public class AdjustableDoubleDataProvider
implements SimSliderDataProvider {
    AdjustableDouble delegate;

    public AdjustableDoubleDataProvider(AdjustableDouble delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getLabel() {
        return this.delegate.isAdjustable() ? this.delegate.getRange().getLabel() : "";
    }

    @Override
    public int getMaxValue() {
        return this.delegate.isAdjustable() ? this.delegate.getRange().doubleToInt(this.delegate.getRange().getMaxValue()) : 0;
    }

    @Override
    public String getValueText() {
        return Double.toString(this.delegate.getValue());
    }

    @Override
    public int getValue() {
        return this.delegate.isAdjustable() ? this.delegate.getRange().doubleToInt(this.delegate.getValue()) : 0;
    }

    @Override
    public void setValue(int value) {
        if (this.delegate.isAdjustable()) {
            this.delegate.setValue(this.delegate.getRange().intToDouble(value));
        }
    }

    @Override
    public Command createCommitCommand(AttributeAccessAdapter attributes) {
        return new AdjustableDoubleChangeCommand(attributes, this.delegate);
    }

    @Override
    public Command createDeleteCommand(AttributeAccessAdapter attributes) {
        return new AdjustableDoubleDeleteCommand(attributes, this.delegate);
    }

    @Override
    public boolean isModified() {
        return this.delegate.isModified();
    }
}

