/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampHelper;

public class TimeUnitHelper {
    String unitId;
    String message;
    String symbol;
    int calendarType;
    long multiplicator;
    static Map byUnitId = null;
    static Map byCalenderType = null;

    private TimeUnitHelper(String unitId, String message, String symbol, int calendarType, long multiplicator) {
        this.unitId = unitId;
        this.message = message;
        this.symbol = symbol;
        this.calendarType = calendarType;
        this.multiplicator = multiplicator;
    }

    private static void addInfo(TimeUnitHelper info) {
        byUnitId.put(info.unitId, info);
        byCalenderType.put(new Integer(info.calendarType), info);
    }

    private static TimeUnitHelper getInfoFor(int calenderType) {
        Integer calenderTypeObj;
        if (byCalenderType == null) {
            TimeUnitHelper.initialize();
        }
        if (!byCalenderType.containsKey(calenderTypeObj = new Integer(calenderType))) {
            throw new RuntimeException("Calender type not supported: <" + calenderType + ">");
        }
        return (TimeUnitHelper)byCalenderType.get(calenderTypeObj);
    }

    private static TimeUnitHelper getInfoFor(String unitId) {
        if (byUnitId == null) {
            TimeUnitHelper.initialize();
        }
        if (!byUnitId.containsKey(unitId)) {
            throw new RuntimeException("Unit not supported: <" + unitId + ">");
        }
        return (TimeUnitHelper)byUnitId.get(unitId);
    }

    private static void initialize() {
        byUnitId = new HashMap();
        byCalenderType = new HashMap();
        TimeUnitHelper.addInfo(new TimeUnitHelper("MILLISECOND", Simulation_Modeling_Messages.UNIT_MILLI, Simulation_Modeling_Messages.SYMBOL_MILLI, 14, 1L));
        TimeUnitHelper.addInfo(new TimeUnitHelper("SECOND", Simulation_Modeling_Messages.UNIT_SECOND, Simulation_Modeling_Messages.SYMBOL_SECOND, 13, 1000L));
        TimeUnitHelper.addInfo(new TimeUnitHelper("MINUTE", Simulation_Modeling_Messages.UNIT_MINUTE, Simulation_Modeling_Messages.SYMBOL_MINUTE, 12, 60000L));
        TimeUnitHelper.addInfo(new TimeUnitHelper("HOUR", Simulation_Modeling_Messages.UNIT_HOUR, Simulation_Modeling_Messages.SYMBOL_HOUR, 10, 3600000L));
        TimeUnitHelper.addInfo(new TimeUnitHelper("DAY", Simulation_Modeling_Messages.UNIT_DAY, Simulation_Modeling_Messages.SYMBOL_DAY, 6, 86400000L));
    }

    public static String getMessage(String unitId) {
        return TimeUnitHelper.getInfoFor((String)unitId).message;
    }

    public static int getCalendarType(String unitId) {
        return TimeUnitHelper.getInfoFor((String)unitId).calendarType;
    }

    public static String getUnitId(int calenderType) {
        return TimeUnitHelper.getInfoFor((int)calenderType).unitId;
    }

    public static String getSymbol(String unitId) {
        return TimeUnitHelper.getInfoFor((String)unitId).symbol;
    }

    public static long getMultiplicator(String unitId) {
        return TimeUnitHelper.getInfoFor((String)unitId).multiplicator;
    }

    public static double getDoubleMultiplicator(String unitId) {
        return TimeUnitHelper.getMultiplicator(unitId);
    }

    public static double getDoubleMultiplicatorSqr(String unitId) {
        return TimeUnitHelper.getDoubleMultiplicator(unitId) * TimeUnitHelper.getDoubleMultiplicator(unitId);
    }

    public static String getMorePrecision(String unitId) {
        if (unitId.equals("MILLISECOND")) {
            return null;
        }
        if (unitId.equals("SECOND")) {
            return "MILLISECOND";
        }
        if (unitId.equals("MINUTE")) {
            return "SECOND";
        }
        if (unitId.equals("HOUR")) {
            return "MINUTE";
        }
        if (unitId.equals("DAY")) {
            return "HOUR";
        }
        throw new RuntimeException("Unit not supported: <" + unitId + ">");
    }

    public static String getLessPrecision(String unitId) {
        if (unitId.equals("MILLISECOND")) {
            return "SECOND";
        }
        if (unitId.equals("SECOND")) {
            return "MINUTE";
        }
        if (unitId.equals("MINUTE")) {
            return "HOUR";
        }
        if (unitId.equals("HOUR")) {
            return "DAY";
        }
        if (unitId.equals("DAY")) {
            return null;
        }
        throw new RuntimeException("Unit not supported: <" + unitId + ">");
    }

    public static String getBestUnit(double time) {
        String[] preferredOrderOnUnits = new String[]{"DAY", "HOUR", "MINUTE", "SECOND"};
        int i = 0;
        while (i < preferredOrderOnUnits.length) {
            if (time >= (double)TimeUnitHelper.getMultiplicator(preferredOrderOnUnits[i])) {
                return preferredOrderOnUnits[i];
            }
            ++i;
        }
        return "MILLISECOND";
    }

    public static long toMilisecond(String unitId, double value) {
        return TimestampHelper.toMilisecond(TimeUnitHelper.getMultiplicator(unitId), value);
    }

    public static double fromMilisecond(String unitId, long milis) {
        return TimestampHelper.fromMilisecond(TimeUnitHelper.getMultiplicator(unitId), milis);
    }
}

