/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleFormat;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyIntegerMinMax;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DiscreteIntegral;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.CurrentConfigurationInfoWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.InputValueDialog;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class AbstractSimulationPanel
extends Composite {
    private static final double AREA_DRAG_EPS = 0.001;
    Font boldFont;
    StackLayoutComposite configStackBox = new StackLayoutComposite(this, 0);
    Composite emptyConfigPanel = new Composite((Composite)this.configStackBox, 0);
    Composite configPanel;
    Button auditCheckBox;
    StackLayoutComposite detailsStackBox;
    Composite emptyDetailsPanel;
    CurrentConfigurationInfoWidget configurationInfo;
    PaintListener verifyModelChangesWrapper;

    public AbstractSimulationPanel(Composite parent, int style) {
        super(parent, style);
        Label emptyConfigLabel = FormBuilder.createLabel((Composite)this.emptyConfigPanel, (String)Simulation_Modeling_Messages.CONFIGURATION_NOT_SELECTED);
        this.configPanel = new Composite((Composite)this.configStackBox, 0);
        Label hr = null;
        if (this.showConfigurationInfoWidget()) {
            this.configurationInfo = new CurrentConfigurationInfoWidget(this.configPanel, 0);
            hr = FormBuilder.createHorizontalSeparator((Composite)this.configPanel, (int)1);
        }
        if (this.showAuditCheckBox()) {
            this.auditCheckBox = FormBuilder.createCheckBox((Composite)this.configPanel, (String)Simulation_Modeling_Messages.DERIVED_FROM_AUDIT_TRAIL);
            this.auditCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractSimulationPanel.this.onAuditCheckBoxChange();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.configStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.emptyConfigPanel);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)emptyConfigLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 8).numColumns(1).applyTo(this.configPanel);
        if (this.configurationInfo != null) {
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.configurationInfo);
            GridDataFactory.fillDefaults().align(4, 1024).grab(true, false).applyTo((Control)hr);
        }
        if (this.auditCheckBox != null) {
            GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)this.auditCheckBox);
        }
        this.configStackBox.setTopControl(this.configPanel);
    }

    protected boolean showConfigurationInfoWidget() {
        return true;
    }

    protected boolean showAuditCheckBox() {
        return true;
    }

    protected void onAuditCheckBoxChange() {
    }

    public void setFromAuditTrailMode(boolean selected) {
        if (this.auditCheckBox != null) {
            this.auditCheckBox.setSelection(selected);
        }
        this.onAuditCheckBoxChange();
    }

    public boolean isFromAuditTrailMode() {
        return this.auditCheckBox != null ? this.auditCheckBox.getSelection() : false;
    }

    public void setFromAuditTrailEnabled(boolean enabled) {
        if (this.auditCheckBox != null) {
            this.auditCheckBox.setEnabled(enabled);
        }
    }

    public void setConfigurationInfo(String configurationName) {
        if (this.configurationInfo != null) {
            this.configurationInfo.setText(configurationName != null ? configurationName : "");
        }
    }

    public void setConfigurationEnabled(boolean enabled) {
        this.configStackBox.setTopControl(enabled ? this.configPanel : this.emptyConfigPanel);
    }

    protected double enterHourValue(double d) {
        return d;
    }

    protected double enterDoubleValue(double d) {
        InputValueDialog dialog = new InputValueDialog(this.getShell(), Simulation_Modeling_Messages.INPUT_VALUE_DIALOG_TITLE, Double.toString(d), new VerifyDoubleFormat());
        if (dialog.open() == 0) {
            return Double.parseDouble(dialog.getValue());
        }
        return d;
    }

    protected double enterPCentValue(double d, double pcentFactor) {
        InputValueDialog dialog = new InputValueDialog(this.getShell(), Simulation_Modeling_Messages.INPUT_VALUE_DIALOG_TITLE, Long.toString(Math.round(d * pcentFactor)), new VerifyIntegerMinMax(0, 100));
        if (dialog.open() == 0) {
            return (double)Integer.parseInt(dialog.getValue()) / pcentFactor;
        }
        return d;
    }

    protected double enterAreaValue(double x, double y, DiscreteIntegral integralCalculator) {
        double oldF = integralCalculator.getIntegral();
        double oldArea = integralCalculator.getIntegralAt(x);
        if (oldF < 0.001 || oldArea < 0.001) {
            return y;
        }
        double oldPercentage = oldArea / oldF;
        double oldOutside = oldF - oldArea;
        double oldXInverse = y / oldArea;
        double newPercentage = this.enterPCentValue(oldPercentage, 100.0);
        if (newPercentage < 0.001) {
            newPercentage = 0.001;
        } else if (newPercentage > 0.999) {
            newPercentage = 0.999;
        }
        double newArea = oldOutside * newPercentage / (1.0 - newPercentage);
        return newArea * oldXInverse;
    }

    protected Font bold(Font f, Display d) {
        if (this.boldFont == null) {
            FontData[] fd = f.getFontData();
            int i = 0;
            while (i < fd.length) {
                fd[i].setStyle(1);
                ++i;
            }
            this.boldFont = new Font((Device)d, fd);
        }
        return this.boldFont;
    }

    protected Label createFill(Composite parent) {
        Label fill = new Label(parent, 0x1000000);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)fill);
        return fill;
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    public static interface VerifyModelChanges {
        public boolean checkForChanges();

        public boolean updateOnChanges();
    }
}

