/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AvailabilityCalendarUtility;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class AdapterForCalendarPopupMenu
implements SelectionListener {
    private static final Object RESET_TO_SELECTED_HOLIDAYS = "RESET_TO_SELECTED_HOLIDAYS";
    private static final Object REMOVE_ALL_HOLIDAYS = "REMOVE_ALL_HOLIDAYS";
    private TimelineEditor editor;
    private Menu menu;
    private Map items = new HashMap();

    public AdapterForCalendarPopupMenu(Shell shell, TimelineEditor editor) {
        this.editor = editor;
        this.menu = new Menu((Decorations)shell, 8);
        if (Platform.getExtensionRegistry() != null) {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stardust.ide.simulation.ui.businesscalendar");
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i].getName().equals("holidays")) {
                    this.createCheckItem(this.menu, extensions[i]);
                } else if (extensions[i].getName().equals("separator")) {
                    this.createSeparator(this.menu);
                } else if (extensions[i].getName().equals("category")) {
                    Menu subMenu = this.createSubMenu(this.menu, extensions[i].getAttribute("name"));
                    IConfigurationElement[] holidayElements = extensions[i].getChildren();
                    int g = 0;
                    while (g < holidayElements.length) {
                        if (holidayElements[g].getName().equals("holidays")) {
                            this.createCheckItem(subMenu, holidayElements[g]);
                        } else if (holidayElements[g].getName().equals("separator")) {
                            this.createSeparator(subMenu);
                        } else {
                            throw new RuntimeException("Unsupported element: <" + holidayElements[g].getName() + ">");
                        }
                        ++g;
                    }
                } else {
                    throw new RuntimeException("Unsupported element: <" + extensions[i].getName() + ">");
                }
                ++i;
            }
            this.createSeparator(this.menu);
            MenuItem resetUserDefinedItem = new MenuItem(this.menu, 8);
            resetUserDefinedItem.setData(RESET_TO_SELECTED_HOLIDAYS);
            resetUserDefinedItem.setText(Simulation_Modeling_Messages.BUSINESS_CALENDAR_POPUP_RESET_TO_SELECTED);
            resetUserDefinedItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Date startDate = AdapterForCalendarPopupMenu.this.editor.getStartDate();
                    Coord2D[] calendarData = AdapterForCalendarPopupMenu.this.editor.getCurveData();
                    String[] lists = AdapterForCalendarPopupMenu.this.getSelectedCalendarIds();
                    int i = 0;
                    while (i < calendarData.length) {
                        Calendar calendar = new TimeCalculator(startDate).add(6, (int)(calendarData[i].getX() - 1.0)).toCalendar();
                        boolean isListedHoliday = AvailabilityCalendarUtility.isOnOneOfLists(lists, calendar);
                        calendarData[i] = isListedHoliday ? new Coord2D(calendarData[i].getX(), 0.0) : new Coord2D(calendarData[i].getX(), 1.0);
                        ++i;
                    }
                    AdapterForCalendarPopupMenu.this.editor.setCurveData(calendarData);
                }
            });
            MenuItem removeAllItem = new MenuItem(this.menu, 8);
            removeAllItem.setData(REMOVE_ALL_HOLIDAYS);
            removeAllItem.setText(Simulation_Modeling_Messages.BUSINESS_CALENDAR_POPUP_REMOVE_ALL);
            removeAllItem.addSelectionListener((SelectionListener)this);
        }
    }

    private Menu createSubMenu(Menu menu, String text) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText(text);
        Menu submenu = new Menu(menu);
        item.setMenu(submenu);
        return submenu;
    }

    private MenuItem createSeparator(Menu menu) {
        return new MenuItem(menu, 2);
    }

    private MenuItem createCheckItem(Menu menu, IConfigurationElement holidaysElement) {
        String text = holidaysElement.getAttribute("name");
        String className = holidaysElement.getAttribute("class");
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Holiday Extension Class <" + className + "> can not be loaded, check the classname/classpath");
            e.printStackTrace(System.out);
        }
        MenuItem item = new MenuItem(menu, 32);
        item.setText(text);
        item.setData((Object)className);
        item.addSelectionListener((SelectionListener)this);
        this.items.put(className, item);
        return item;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        MenuItem item = (MenuItem)e.widget;
        String menuItemId = (String)item.getData();
        Date startDate = this.editor.getStartDate();
        Coord2D[] calendarData = this.editor.getCurveData();
        String[] lists = this.getSelectedCalendarIds();
        int i = 0;
        while (i < calendarData.length) {
            Calendar calendar = new TimeCalculator(startDate).add(6, (int)(calendarData[i].getX() - 1.0)).toCalendar();
            if (REMOVE_ALL_HOLIDAYS.equals(menuItemId)) {
                calendarData[i] = calendarData[i].max(new Coord2D(0.0, 1.0));
            } else {
                boolean isSelectedMenuItem = AvailabilityCalendarUtility.isOnList(menuItemId, calendar.getTime().getTime());
                if (isSelectedMenuItem) {
                    boolean isListedHoliday = AvailabilityCalendarUtility.isOnOneOfLists(lists, calendar);
                    calendarData[i] = isListedHoliday ? new Coord2D(calendarData[i].getX(), 0.0) : new Coord2D(calendarData[i].getX(), 1.0);
                }
            }
            ++i;
        }
        this.editor.setCurveData(calendarData);
        if (REMOVE_ALL_HOLIDAYS.equals(menuItemId)) {
            this.setSelectedCalendarIds(new String[0]);
        }
    }

    public String[] getSelectedCalendarIds() {
        LinkedList<Object> selected = new LinkedList<Object>();
        for (MenuItem menuItem : this.items.values()) {
            if (!menuItem.getSelection()) continue;
            selected.add(menuItem.getData());
        }
        return selected.toArray(new String[selected.size()]);
    }

    public void setSelectedCalendarIds(String[] predefinedCalendarsArray) {
        List<String> predefinedCalendars = Arrays.asList(predefinedCalendarsArray);
        for (MenuItem menuItem : this.items.values()) {
            menuItem.setSelection(predefinedCalendars.contains(menuItem.getData()));
        }
    }
}

