/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.text.MessageFormat;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2DList;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class AdapterForCurvePopupMenu {
    private TimelineEditor editor;
    private Menu menu;

    public static AdapterForCurvePopupMenu createAvailavilityMenu(Shell shell, TimelineEditor editor) {
        return new AdapterForCurvePopupMenu(shell, editor, 1.0, "1", true, true, true, false, true, false);
    }

    public static AdapterForCurvePopupMenu createDailyMenu(Shell shell, TimelineEditor editor) {
        return new AdapterForCurvePopupMenu(shell, editor, 1.0, "100%", true, true, true, false, true, false);
    }

    public static AdapterForCurvePopupMenu createProbabilityMenu(Shell shell, TimelineEditor editor) {
        return new AdapterForCurvePopupMenu(shell, editor, 100.0, "100%", true, true, true, false, true, false);
    }

    public static AdapterForCurvePopupMenu createArrivalRateMenu(Shell shell, TimelineEditor editor) {
        return new AdapterForCurvePopupMenu(shell, editor, 1.0, "100%", false, false, false, true, true, false);
    }

    public AdapterForCurvePopupMenu(Shell shell, TimelineEditor editor, final double defaultValue, String defaultValueLabel, boolean showRemoveAll, boolean showResetToZero, boolean showResetToDefaultValue, boolean showResetToDefaultArea, boolean showOptimize, boolean showEditDetails) {
        MenuItem item;
        this.editor = editor;
        this.menu = new Menu((Decorations)shell, 8);
        if (showRemoveAll) {
            item = new MenuItem(this.menu, 8);
            item.setText(Simulation_Modeling_Messages.TIMELINE_POPUP_REMOVE_ALL_POINTS);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onRemoveAllPoints();
                }
            });
        }
        if (showResetToZero) {
            item = new MenuItem(this.menu, 8);
            item.setText(Simulation_Modeling_Messages.TIMELINE_POPUP_RESET_TO_ZERO);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onResetValue(0.0);
                }
            });
        }
        if (showResetToDefaultValue) {
            item = new MenuItem(this.menu, 8);
            item.setText(MessageFormat.format(Simulation_Modeling_Messages.TIMELINE_POPUP_RESET_TO_DEFAULT, defaultValueLabel));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onResetValue(defaultValue);
                }
            });
        }
        if (showResetToDefaultArea) {
            item = new MenuItem(this.menu, 8);
            item.setText(MessageFormat.format(Simulation_Modeling_Messages.TIMELINE_POPUP_RESET_TO_DEFAULT, defaultValueLabel));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onResetToDefaultArea();
                }
            });
        }
        if (showOptimize) {
            item = new MenuItem(this.menu, 8);
            item.setText(Simulation_Modeling_Messages.TIMELINE_POPUP_OPTIMIZE_CURVE);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onOptimize();
                }
            });
        }
        if (showEditDetails) {
            item = new MenuItem(this.menu, 2);
            item = new MenuItem(this.menu, 8);
            item.setText(Simulation_Modeling_Messages.TIMELINE_POPUP_EDIT_DETAILS);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdapterForCurvePopupMenu.this.onOpenMoreOptions();
                }
            });
        }
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void onRemoveAllPoints() {
        Coord2D[] oldCurve = this.editor.getCurveData();
        Coord2D[] newCurve = new Coord2D[]{oldCurve[oldCurve.length - 1]};
        this.editor.setCurveData(newCurve);
    }

    public void onResetValue(double defaultValue) {
        Coord2D[] oldCurve = this.editor.getCurveData();
        Coord2D[] newCurve = new Coord2D[oldCurve.length];
        int i = 0;
        while (i < newCurve.length) {
            newCurve[i] = new Coord2D(oldCurve[i].getX(), defaultValue);
            ++i;
        }
        this.editor.setCurveData(newCurve);
    }

    public void onResetToDefaultArea() {
        Coord2D[] oldCurve = this.editor.getCurveData();
        Coord2D[] newCurve = new Coord2D[]{new Coord2D(oldCurve[oldCurve.length - 1].getX(), 1.0)};
        this.editor.setCurveData(newCurve);
    }

    public void onOptimize() {
        Coord2D[] oldCurve = this.editor.getCurveData();
        Coord2DList newCurve = new Coord2DList();
        double maxY = 0.0;
        int i = 1;
        while (i < oldCurve.length) {
            maxY = Math.max(maxY, oldCurve[i].getY());
            ++i;
        }
        i = 1;
        while (i < oldCurve.length) {
            double prevY = oldCurve[i - 1].getY();
            double nextY = oldCurve[i].getY();
            if (this.isNearZero(prevY, maxY)) {
                if (!this.isNearZero(nextY, maxY)) {
                    newCurve.add(new Coord2D(oldCurve[i - 1].getX(), 0.0));
                }
            } else if (this.isMoreThan10PCentDiff(prevY, nextY)) {
                newCurve.add(oldCurve[i - 1]);
            }
            ++i;
        }
        newCurve.add(oldCurve[oldCurve.length - 1]);
        this.editor.setCurveData(newCurve.toArray());
    }

    public void onOpenMoreOptions() {
    }

    private boolean isNearZero(double y, double max) {
        return max <= 1.0 ? Math.abs(y) < 0.01 : Math.abs(y) < 1.0;
    }

    private boolean isMoreThan10PCentDiff(double y1, double y2) {
        return Math.abs(y2 - y1) * 10.0 > Math.min(y2, y1);
    }
}

