/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleFormat;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AdapterForDoubleWidget {
    LabelWithStatus label;
    Text control;
    DecimalFormat precisionFormatter;
    double minValue = 0.0;
    double maxValue = 0.0;
    double defaultValue = 0.0;
    VerifyDoubleFormat verify;

    public AdapterForDoubleWidget(Composite parent, int style, String labelText) {
        this.label = FormBuilder.createLabelWithRightAlignedStatus((Composite)parent, (String)labelText);
        this.control = new Text(parent, style);
        this.control.setToolTipText(labelText);
    }

    public void configure(int precision, double min, double max, double inc) {
        this.precisionFormatter = new DecimalFormat("0.000000000".substring(0, 2 + precision), new DecimalFormatSymbols(Locale.US));
        this.defaultValue = min;
        this.minValue = min;
        this.maxValue = max;
        this.verify = new VerifyDoubleFormat();
        this.control.addFocusListener((FocusListener)this.verify);
        this.control.addVerifyListener((VerifyListener)this.verify);
    }

    public void reconfigure(double min, double max) {
    }

    public LabelWithStatus getLabel() {
        return this.label;
    }

    public Control getControl() {
        return this.control;
    }

    public double getValue() {
        return this.convert(this.control.getText());
    }

    public void setValue(double value) {
        this.control.setText(this.convert(value));
    }

    public void setValue(Double value) {
        this.setValue(value != null ? value : 0.0);
    }

    public void addModifyListener(ModifyListener listener) {
        this.control.addModifyListener(listener);
    }

    public double verify(double value) {
        if (value < this.minValue || value > this.maxValue) {
            this.label.setValidationStatus(IQuickValidationStatus.ERRORS);
            this.label.setToolTipText(String.valueOf(Simulation_Modeling_Messages.ERROR_VALUE_OUTSIDE_OF_RANGE) + " " + Simulation_Modeling_Messages.ERROR_TRAY_OTHER_TIME_UNIT);
            return Math.max(this.minValue, Math.min(this.maxValue, value));
        }
        this.label.setValidationStatus(IQuickValidationStatus.OK);
        this.label.setToolTipText("");
        return value;
    }

    public double convert(String s) {
        try {
            return this.verify(Double.parseDouble(s));
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String convert(double value) {
        value = this.verify(value);
        return this.precisionFormatter == null ? Double.toString(value) : this.precisionFormatter.format(value);
    }
}

