/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DiscreteIntegral;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.FormatUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;

public class TimelineWidgetTooltips
extends DragListener.Stub {
    private TimelineEditor editor;

    public TimelineWidgetTooltips(TimelineEditor editor) {
        this.editor = editor;
    }

    public void onPoint(Coord2D source, int direction) {
        if ((direction & 0x100) != 0) {
            this.showHorizontal(source);
        } else if ((direction & 0x200) != 0) {
            if (this.isIntegralBasedValue()) {
                double value = this.calculateIntegral(source.getX());
                if (Double.isNaN(value)) {
                    this.editor.setToolTipText(null);
                } else {
                    this.editor.setToolTipText(FormatUtils.PERCENT_FORMAT.format(value));
                }
            } else {
                this.showVertical(source);
            }
        } else {
            this.showNone();
        }
    }

    public void onDrag(Coord2D source, Coord2D target, int direction) {
        if ((direction & 0x100) != 0) {
            this.showHorizontal(target);
        } else if (this.isIntegralBasedValue()) {
            double value = this.calculateDragIntegral(source.getX(), source.getY(), target.getY());
            if (Double.isNaN(value)) {
                this.editor.setToolTipText(null);
            } else {
                this.editor.setToolTipText(FormatUtils.PERCENT_FORMAT.format(value));
            }
        } else {
            this.showVertical(target);
        }
    }

    public void onDragEnd() {
        this.showNone();
    }

    private void showHorizontal(Coord2D coord) {
        Date startDate = this.editor.getStartDate();
        if (startDate != null) {
            TimeCalculator calculator = new TimeCalculator(startDate);
            if (this.editor.getType() == 3) {
                calculator.add(6, (int)coord.getX());
                this.editor.setToolTipText(FormatUtils.DAY_FORMAT.format(calculator.toDate()));
            } else if (this.editor.getType() == 2) {
                calculator.add(6, (int)coord.getX());
                this.editor.setToolTipText(FormatUtils.DAY_FORMAT.format(calculator.toDate()));
            } else if (this.editor.getType() == 5) {
                calculator.add(6, (int)coord.getX());
                this.editor.setToolTipText(FormatUtils.DAY_FORMAT.format(calculator.toDate()));
            } else if (this.editor.getType() == 1) {
                int hour = (int)coord.getX();
                int minute = (int)((coord.getX() - (double)hour) * 60.0);
                calculator.add(10, hour);
                calculator.add(12, minute);
                this.editor.setToolTipText(FormatUtils.HOUR_FORMAT.format(calculator.toDate()));
            } else if (this.editor.getType() == 4) {
                this.editor.setToolTipText(FormatUtils.DEFAULT_VALUE_FORMAT.format(coord.getX()));
            } else if (this.editor.getType() == 6) {
                int hour = (int)coord.getX();
                int minute = (int)((coord.getX() - (double)hour) * 60.0);
                calculator.add(10, hour);
                calculator.add(12, minute);
                this.editor.setToolTipText(FormatUtils.HOUR_FORMAT.format(calculator.toDate()));
            } else {
                this.editor.setToolTipText(FormatUtils.DEFAULT_VALUE_FORMAT.format(coord.getX()));
            }
        } else {
            this.editor.setToolTipText(FormatUtils.DEFAULT_VALUE_FORMAT.format(coord.getX()));
        }
    }

    private boolean isIntegralBasedValue() {
        return this.editor.getType() == 6 || this.editor.getType() == 4;
    }

    private void showVertical(Coord2D source) {
        if (this.editor.getType() == 1) {
            this.editor.setToolTipText(FormatUtils.PERCENT_FORMAT.format(source.getY()));
        } else if (this.editor.getType() == 5) {
            this.editor.setToolTipText(String.valueOf(FormatUtils.DEFAULT_VALUE_FORMAT.format(source.getY())) + "%");
        } else {
            this.editor.setToolTipText(FormatUtils.DEFAULT_VALUE_FORMAT.format(source.getY()));
        }
    }

    private void showNone() {
        this.editor.setToolTipText("");
    }

    private double calculateIntegral(double x) {
        DiscreteIntegral integralCalculator = this.editor.getCurveIntegralCalculator();
        return integralCalculator.getIntegralAt(x) / integralCalculator.getIntegral();
    }

    private double calculateDragIntegral(double x, double oldY, double newY) {
        DiscreteIntegral integralCalculator = this.editor.getCurveIntegralCalculator();
        double F = integralCalculator.getIntegral();
        double f = integralCalculator.getIntegralAt(x);
        double w = integralCalculator.getWidthAt(x);
        double plus = (newY - oldY) * w;
        return (f + plus) / (F + plus);
    }
}

