/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.visitors;

import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DurationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelTraversalVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;

public class ChangeRetrieveFromAuditTrailVisitor
implements ModelVisitor {
    int configurationId;
    SimulationInterval interval;
    boolean enable;

    public ChangeRetrieveFromAuditTrailVisitor(ModelType model, SimulationConfiguration simulationConfiguration, boolean enable) {
        this.enable = enable;
        this.configurationId = simulationConfiguration.getId();
        this.interval = simulationConfiguration.getInterval();
        new ModelTraversalVisitor(this, model);
    }

    @Override
    public void visit(ModelType model) {
        this.interval = new SimulationConfiguration(this.configurationId, model).getInterval();
    }

    @Override
    public void visit(ProcessDefinitionType element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setFromAuditTrail(this.enable);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(ActivityType element) {
        boolean applicationWithDuration;
        ActivityImplementationType implementation = element.getImplementation();
        ApplicationType application = element.getApplication();
        boolean activityWithDuration = implementation != null && (implementation.getValue() == 1 || implementation.getValue() == 0);
        boolean bl = applicationWithDuration = application != null && application.isInteractive();
        if (activityWithDuration || applicationWithDuration) {
            DurationConfiguration configuration = new DurationConfiguration(this.interval);
            configuration.read((IExtensibleElement)element, this.configurationId);
            configuration.setFromAuditTrail(this.enable);
            configuration.write((IExtensibleElement)element, this.configurationId);
        }
    }

    @Override
    public void visit(ApplicationType element) {
        AbstractRetrievableSimulationSubConfiguration configuration;
        if (!element.isInteractive()) {
            configuration = new AvailabilityConfiguration(this.interval);
            configuration.read((IExtensibleElement)element, this.configurationId);
            configuration.setFromAuditTrail(this.enable);
            if (this.enable) {
                ((AvailabilityConfiguration)configuration).setUnlimited(false);
            }
            configuration.write((IExtensibleElement)element, this.configurationId);
        }
        configuration = new DurationConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setFromAuditTrail(this.enable);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(IModelParticipant element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setFromAuditTrail(this.enable);
        if (this.enable) {
            configuration.setUnlimited(false);
        }
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(TransitionType element) {
        ProbabilityConfiguration configuration = new ProbabilityConfiguration(this.interval, SimulationModelUtils.calculateDefaultProbability((IModelElement)element));
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setFromAuditTrail(this.enable);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(DataType element) {
    }
}

