/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.slider.gui;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class WorkflowEditorExtendedView
extends ViewPart {
    EventDispatcher pageEventDispatcher;

    protected abstract void updateOnSelectionChange(boolean var1);

    public void initializePageEventDispatcher() {
        this.pageEventDispatcher = new EventDispatcher(this);
        this.pageEventDispatcher.partActivated(this.getSite().getPage().getActivePart());
    }

    public WorkflowModelEditor getCurrentEditor() {
        return this.pageEventDispatcher.currentEditor;
    }

    public void dispose() {
        if (this.pageEventDispatcher != null) {
            this.pageEventDispatcher.dispose();
        }
        super.dispose();
    }

    protected static class EventDispatcher
    implements IPartListener,
    NotificationAdaptee {
        WorkflowEditorExtendedView owner;
        WorkflowModelEditor currentEditor;
        NotificationAdapter notificationAdapter;

        public EventDispatcher(WorkflowEditorExtendedView owner) {
            this.owner = owner;
            this.notificationAdapter = new NotificationAdapter((NotificationAdaptee)this);
            owner.getSite().getPage().addPartListener((IPartListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part != null && part instanceof WorkflowModelEditor) {
                this.detach();
                this.currentEditor = (WorkflowModelEditor)part;
                this.owner.updateOnSelectionChange(true);
                this.attach();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            this.partActivated(part);
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this.currentEditor) {
                this.detach();
                this.currentEditor = null;
            }
        }

        public Object getModel() {
            return null;
        }

        public void handleNotification(Notification notification) {
            if (notification.getEventType() == 8) {
                return;
            }
            this.owner.updateOnSelectionChange(false);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void dispose() {
            this.detach();
            this.owner.getSite().getPage().removePartListener((IPartListener)this);
            this.currentEditor = null;
        }

        private void attach() {
            if (this.currentEditor != null) {
                this.currentEditor.getWorkflowModel().eAdapters().add((Object)this.notificationAdapter);
            }
        }

        private void detach() {
            if (this.currentEditor != null) {
                this.currentEditor.getWorkflowModel().eAdapters().remove((Object)this.notificationAdapter);
            }
        }
    }
}

