/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;

public class Interval
extends Timestamp {
    long duration;

    public Interval(long timestamp, long duration) {
        super(timestamp);
        this.duration = duration;
    }

    public Interval shift(long millis) {
        return new Interval(this.time - millis, this.duration);
    }

    @Override
    public Timestamp shiftBackwards(long millis) {
        return new Interval(this.time - millis, this.duration);
    }

    public Timestamp getStartTimestamp() {
        return new Timestamp(this.time);
    }

    public Timestamp getEndTimestamp() {
        return new Timestamp(this.time + this.duration);
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public Long getKey() {
        return new Long(this.time);
    }

    @Override
    public String toString() {
        return String.valueOf(DateFormat.getDateTimeInstance(3, 1).format(new Date(this.time))) + " (" + this.time + ")" + " - " + DateFormat.getDateTimeInstance(3, 1).format(new Date(this.time + this.duration)) + " (" + (this.time + this.duration) + ")";
    }
}

