/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.Calendar;
import java.util.Iterator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;

public class TimeIterator
implements Iterator {
    Calendar nextDay;
    Calendar endDay;
    int stepByUnit;
    int stepSize;

    public TimeIterator(Timestamp startDay, Timestamp endDay, int stepByUnit, int stepSize) {
        this.nextDay = startDay.getCalendar();
        this.endDay = endDay.getCalendar();
        this.stepByUnit = stepByUnit;
        this.stepSize = stepSize;
    }

    public TimeIterator(Timestamp startDay, Timestamp endDay, int stepByUnit) {
        this(startDay, endDay, stepByUnit, 1);
    }

    public TimeIterator(Calendar startDay, Calendar endDay, int stepByUnit, int stepSize) {
        this(new Timestamp(startDay), new Timestamp(endDay), stepByUnit, stepSize);
    }

    @Override
    public boolean hasNext() {
        return !this.nextDay.after(this.endDay);
    }

    public Object next() {
        Timestamp result = new Timestamp(this.nextDay.getTimeInMillis());
        this.nextDay.add(this.stepByUnit, this.stepSize);
        return result;
    }

    @Override
    public void remove() {
    }
}

