/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;

public class TimestampValue
extends Timestamp {
    static final double EPS = 1.0E-6;
    double value = 0.0;

    public TimestampValue(long timestamp, double value) {
        super(timestamp);
        this.value = value;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp);
    }

    public TimestampValue(Timestamp other, double value) {
        this(other.time, value);
    }

    public TimestampValue(long unit, double xvalue, double value) {
        super(Math.round((double)unit * xvalue));
        this.value = value;
    }

    public Timestamp normalize(double value100Pcent) {
        return new TimestampValue(this.time, value100Pcent > 1.0E-6 ? this.value / value100Pcent : 0.0);
    }

    public Timestamp shift(long millis) {
        return new TimestampValue(this.time + millis, this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }

    public void addValue(double v) {
        this.value += v;
    }

    @Override
    public String toString() {
        return String.valueOf(DateFormat.getDateTimeInstance(3, 1).format(new Date(this.time))) + " (" + this.time + ")" + " = " + this.value;
    }

    public static String objectToString(TimestampValue o) {
        return new StringBuffer("[").append(o.time).append(";").append(o.value).append("]").toString();
    }

    public static TimestampValue stringToObject(String s) {
        s = s.replaceAll("(^\\[)|(\\]$)", "");
        String[] values = s.split(";");
        return new TimestampValue(Long.parseLong(values[0]), Double.parseDouble(values[1]));
    }

    public static List stringToList(String string) {
        ArrayList result = new ArrayList();
        TimestampValue.stringToList(result, string);
        return result;
    }

    public static void stringToList(List result, String string) {
        if (string != null) {
            String[] pairs = string.split("(^\\[)|(\\]\\[)|(\\]$)", -1);
            int i = 0;
            while (i < pairs.length) {
                if (pairs[i].length() > 0) {
                    String[] values = pairs[i].split(";");
                    result.add(new TimestampValue(Long.parseLong(values[0]), Double.parseDouble(values[1])));
                }
                ++i;
            }
        }
    }

    public static String listToString(List list) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(TimestampValue.objectToString((TimestampValue)iter.next()));
        }
        return sb.toString();
    }
}

